public class Spring extends PhysicsElement  {

   protected static int id=0;  // Spring identification
   protected final float restLength;

   //POR LOS 5 PUNTOS ahora stiffness no es final, se puede editar
   private float stiffness;
   protected AttachableElement a_end, b_end;

   private Spring(){   // nobody can create a block without state (children can see this method)
      super(id++);
      stiffness = restLength = 0;
   }
   public Spring(float restLength, float stiffness){
      super(id++);
      this.restLength = restLength;
      this.stiffness = stiffness;
      a_end = b_end = null;
   }
   public void attachAend (AttachableElement ae) {
      a_end = ae;
      ae.attachSpring(this);
   }
   public void detachAend(){
      if (a_end == null) return;
      a_end.detachSpring(this);
      a_end=null;
   }
   public void attachBend (AttachableElement ae) {
      b_end = ae;
      ae.attachSpring(this);
   }
   public void detachBend(){
      if (b_end == null) return;
      b_end.detachSpring(this);
      b_end = null;
   }
   public Vector2D getAendPosition() {
      if (a_end != null)
         return a_end.getPosition();
      if (b_end != null)
         return b_end.getPosition().minus(new Vector2D(0,restLength));
      return new Vector2D();
   }
   public Vector2D getBendPosition() {
      if (b_end != null)
         return b_end.getPosition();
      if (a_end != null)
         return a_end.getPosition().plus(new Vector2D(0,restLength));
      return new Vector2D(0,restLength);
   }
   protected Vector2D getVector() {
      return getBendPosition().minus(getAendPosition());
   }
   public Vector2D getForce(AttachableElement ae) {
      Vector2D force = new Vector2D();
      if ((a_end == null) || (b_end == null))
         return force;
      if ((ae != a_end) && (ae != b_end))
         return force;
      Vector2D springVector = getVector();
      double stretch = springVector.module() - restLength;
      force = springVector.unitary().times(stretch*stiffness);
      if (ae == a_end) return force;
      return force.times(-1.0);
   }
   public String getDescription() {
      return "Spring_"+ getId()+": "+ Vector2D.getDescription()+" ,"+ Vector2D.getDescription();
   }
   public String getState() {
      String s = getAendPosition() + "," + getBendPosition();
      return s;
   }

   //Metodo para saber la constante del resorte (o rubber)
   public float getStiffness(){
       return stiffness;
   }

   //Metodo para setear constante
   public void setStiffness(float newStiffness){
       stiffness = newStiffness;
   }

   //Metodos para eliminar referencias de b_end y a_end del objeto que quiero eliminar
   public void detachThisElement(AttachableElement ae){
       if(a_end == ae)
           detachAend();

       if(b_end == ae)
           detachBend();
   }

}
