/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 *
 * @author hev
 * Clase que simula un Elastico
 */
public class Rubber extends Spring {

/**
 * Constructor por defecto, nadie puede crear Elasticos sin estado
 */
    private Rubber(){   //Nobody can create a Rubber without state
        super(0,0);    //Call on the father's constructor
    }
/**
 * Constructor
 * @param restLength    El largo en reposo
 * @param stiffness     La constante elastica
 */
    public Rubber(float restLength, float stiffness){
      super(restLength, stiffness);

   }


    /**
     * Obtener la fuerza actual que ejerce el elastico a cierto objeto
     * @param ae    El objeto que desea conocer la fuerza que ejerce el elastico a el
     * @return  Devuelve la fuerza en formato Vector2D
     */
    public Vector2D getForce(AttachableElement ae){
        Vector2D force = super.getForce(ae);

        //Get the stretch
        Vector2D springVector = getVector();
        double stretch = springVector.module() - restLength;


        if(stretch <= restLength)
            return new Vector2D(0,0);

        else return force;
    }

}
