import javax.swing.JPanel;
import java.awt.Graphics;
import java.awt.Graphics2D;

public class PhysicsLabPanel extends JPanel { 
   private MyWorld world;
   private MouseListener mListener;
   
   public PhysicsLabPanel(MyWorld w){
      world = w;
      mListener = new MouseListener(w, this);
      addMouseMotionListener(mListener);
      addMouseListener(mListener);
   }
   public void paintComponent(Graphics g){
      super.paintComponent(g); // it paints the background
      Graphics2D g2 = (Graphics2D)g;
      world.paintComponent(g2);
   }
   public void enableMouseListener(){
      addMouseMotionListener(mListener);
      addMouseListener(mListener);         
   }
   public void desableMouseListener(){
      removeMouseMotionListener(mListener);
      removeMouseListener(mListener);
   }
}
