import javax.swing.JFrame;
import javax.swing.*;
import java.awt.Container;

public class PhysicsLab {
   public static void main(String[] args) {
      PhysicsLabFrame labFrame = new PhysicsLabFrame();
      labFrame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
      labFrame.setVisible(true);
   }
}

class PhysicsLabFrame extends JFrame {
   public PhysicsLabFrame() {
      setTitle("Small Physics Laboratory");
      setSize(MyWorld.WIDTH, MyWorld.HEIGHT+50);
      MyWorld world = new MyWorld();
      PhysicsLabPanel labPanel = new PhysicsLabPanel(world);
      add(labPanel);  // it is equivalent to getContentPane().add(...);
      world.setPanel(labPanel);   // to repaint view when model changes
      ConfigurationMenuListener cListener = new ConfigurationMenuListener(world);
      WorldControlMenuListener wcListener = new WorldControlMenuListener(world);
      setJMenuBar(createLabMenuBar(cListener, wcListener));
   }

   public JMenuBar createLabMenuBar(ConfigurationMenuListener cl, WorldControlMenuListener wl) {
      JMenuBar mb = new JMenuBar();
      
      JMenu menu = new JMenu ("Configuration");
      mb.add(menu);
      JMenu subMenu = new JMenu("Insert");  
      menu.add(subMenu);
      //I should need to give a pointer to this Menu to WorldControlMenuListener
      //So it can Gray it out when start is clicked, and make it come back when 
      //Stop is clicked
      wl.setInsertMenuItemPointer(subMenu);

      //Now we keep creating the JMenuItems
      JMenuItem menuItem = new JMenuItem("Ball");
      menuItem.addActionListener(cl);
      subMenu.add(menuItem);
      menuItem = new JMenuItem("Fixed Hook");
      menuItem.addActionListener(cl);
      subMenu.add(menuItem);
      menuItem = new JMenuItem("Spring");
      menuItem.addActionListener(cl);
      subMenu.add(menuItem);
      //Adding the Rubber
      menuItem = new JMenuItem("Rubber");
      menuItem.addActionListener(cl);
      subMenu.add(menuItem);

      //TODO here i should add the Delete Item, and give him de ConfListener
      menuItem = new JMenuItem("Delete");
      menuItem.addActionListener(cl);
      //Add it to the Configuration Menu
      menu.add(menuItem);
      //Is not necesary to disable the Delete during simulation due to the Mouselistener
      //Being disabled

      //THIS IS FOR THE 5 EXTRA POINTS:
      //AGREGAR UNA FORMA PARA EDITAR LA MASA Y CONSTANTES ELASTICAS
      //SE OPTA POR USAR UN MENU ITEM (VERSUS HACER DOBLE CLICK.. EL CUAL ERA
      //OTRA OPCION
      menuItem = new JMenuItem("Edit Parameters");
      menuItem.addActionListener(cl);
      menu.add(menuItem);
      
      menu = new JMenu("MyWorld");
      mb.add(menu);
      menuItem = new JMenuItem("Start");
      menuItem.addActionListener(wl);
      menu.add(menuItem);
      //Se agrega Resume (ponerlo bajo Start es mas predeterminado
      menuItem = new JMenuItem("Resume");
      menuItem.addActionListener(wl);
      menu.add(menuItem);

      //Se continua con lo original
      menuItem = new JMenuItem("Stop");
      menuItem.addActionListener(wl);
      menu.add(menuItem);
      menuItem = new JMenuItem("Gravity");
      menuItem.addActionListener(wl);
      menu.add(menuItem);
      menuItem = new JMenuItem("Viscosity");
      menuItem.addActionListener(wl);
      menu.add(menuItem);
      subMenu = new JMenu("Simulator");
      menu.add(subMenu);
      menuItem = new JMenuItem("Delta time");
      menuItem.addActionListener(wl);
      subMenu.add(menuItem);
      menuItem = new JMenuItem("Graphics Refresh time");
      menuItem.addActionListener(wl);
      subMenu.add(menuItem);

      

      return mb;          
   }   
}
