import javax.swing.Timer;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import java.awt.Graphics2D;
import java.util.*;
import java.awt.Cursor;

public class MyWorld implements ActionListener {
   public static int WIDTH = 600;  // in pixels
   public static int HEIGHT = 500; // in pixels
   private double t;              // Simulation time
   private Timer pase;
   private double delta_t;        // in seconds
   private double refreshPeriod;  // in seconds
   
   private Vector2D g;
   private float viscosity;
   private PhysicsLabPanel labPanel;
   private Vector<PhysicsElement> elements;

   //Here we add the is Delete enabled variable so i can know when
   //The delete option of the configure menu is pressed
   private boolean isDeleteEnabled;

   //Same as the above situation.. we set a variable to know when the
   //Edit Parameters was pressed
   private boolean isEditParametersEnabled;

   public MyWorld(){
      t = 0;
      refreshPeriod = 0.06;      // 80 [ms]
      delta_t = 0.0001;          // 0.1 [ms]
      pase = new Timer((int)(refreshPeriod*1000), this);
      g = new Vector2D(0, 0);
      viscosity = 0.0f;
      elements = new Vector<PhysicsElement>();
      labPanel = null;

      //Add the bool to the constructor
      isDeleteEnabled = false;
      isEditParametersEnabled = false;
   }
   public void setPanel (PhysicsLabPanel p) {
      labPanel = p;
   }
   public void setDelta_t(double delta) {
      delta_t = delta;
   }
   public void setRefreshPeriod (double rp) {
      refreshPeriod = rp;
      pase.setDelay((int)(refreshPeriod*1000));
   }
   public void setGravity (Vector2D gravity) {
      g = gravity;
   }
   public void setViscosity(float v){
      viscosity = v;
   }
   public void addElement(PhysicsElement e) {
      elements.add(e);
      labPanel.repaint();
   }

   //Se cambia metodo Start para que le cambie las velocidades iniciales a las pelotas
   public void start() {
      if(pase.isRunning()) return;
      for (PhysicsElement e: elements){
         e.setInitialState(g, viscosity);
         
         //Si es una instancia de Ball se debe resetear su velocidad y aceleracion
         if(e instanceof Ball){
             Ball eBall = (Ball) e;
             eBall.resetVelocityAndAcceleration();
          }
       }

       //desable??? (disable)
      labPanel.desableMouseListener();
      pase.start();      
   }
   public void stop(){
      pase.stop();
      labPanel.enableMouseListener();
   }

   //Se agrega metodo resume, basicamente es el mismo metodo start() original
   public void resume() {
      if(pase.isRunning()) return;
      for (PhysicsElement e: elements)
         e.setInitialState(g, viscosity);
      labPanel.desableMouseListener();
      pase.start();
   }

   public void actionPerformed (ActionEvent event) {  // simulate passing time
      double nextStop=t+refreshPeriod;
      for (; t<nextStop; t+=delta_t){
      for (PhysicsElement e: elements)
         e.computeNextState(delta_t, g, viscosity);
      for (PhysicsElement e: elements)
         e.updateState();
      }
      labPanel.repaint();
   }
   public void paintComponent(Graphics2D g2d){
      for (PhysicsElement e: elements)
         if (e instanceof Drawable)
            ((Drawable)e).draw(g2d);
   }
   public Drawable find(int x, int y) {
      for (PhysicsElement e: elements)
         if (e instanceof Drawable){
            Drawable de = (Drawable) e;
            if (de.contains(x,y)) return de;
         }
      return null;
   }  

   public AttachableElement findAttachableElement(int x, int y) {
      for (PhysicsElement e :elements)
         if (e instanceof AttachableElement) {
            AttachableElement ae =(AttachableElement) e;
            if (ae instanceof Drawable)
            if (((Drawable)ae).contains(x,y)) return ae;
         }
      return null;
   }

   //Metodo para setear variable delete a true
   public void setDeleteEnabled(){
       isDeleteEnabled = true;

       //Set the cursor to cross shaped
       labPanel.setCursor(new Cursor(Cursor.CROSSHAIR_CURSOR));
   }

   //Metodo para setear variable delete a false
   public void setDeleteDisabled(){
       isDeleteEnabled = false;

       //Set the default cursor
       labPanel.setCursor(new Cursor(Cursor.DEFAULT_CURSOR));
   }

   //Metodo para obtener valor de variable delete
   public boolean isDeleteEnabled(){
       return isDeleteEnabled;
   }

   //Need method for deleting objects
   //Este metodo borra el elemento pasado como argumento
   public void deleteElement(PhysicsElement e){
       //Se debe tener especial cuidado con los resortes, dado que se puede borrar
       //La referencia existente en myworld.. pero cada pelota conectada a el resorte
       //tiene una referencia al resorte al que esta conectado. Para que Garbage Collection
       //funcione.. no debe haber NINGUNA referencia al objeto

       //Si el elemento eliminado es un resorte
       if(e instanceof Spring){
           Spring es = (Spring) e;

           //Debo ir elemento por elemento eliminando referencia al spring
           for(PhysicsElement f: elements){
                if(f instanceof AttachableElement){
                    AttachableElement attach = (AttachableElement) f;
                    attach.detachSpring(es);
                }

       }
       }

       //Si el objeto es un elemento enganchable, se debe borrar las referencias en
       //Los Spring (rubber o spring) que tenga enganchado
       if(e instanceof AttachableElement){
           AttachableElement ae = (AttachableElement) e;

           //Eliminar las referencias del elemento en todos los spring
           for(PhysicsElement f: elements)
               if(f instanceof Spring){
                   Spring spring = (Spring) f;
                   spring.detachThisElement(ae);
               }

       }

       elements.remove(e);
   }

   //Metodo que se utiliza para setear variable Edit Par.. a true
   public void setEditParametersEnabled(){
       isEditParametersEnabled = true;

       //Setear Cursor a otra forma
       labPanel.setCursor(new Cursor(Cursor.TEXT_CURSOR));
   }

   public void setEditParametersDisabled(){
       isEditParametersEnabled = false;

       //Devolver cursor a estado original
       labPanel.setCursor(new Cursor(Cursor.DEFAULT_CURSOR));
   }

   //Devuelve valor de Edit Parameters
   public boolean isEditParametersEnabled(){
       return isEditParametersEnabled;
   }
   
}

