import javax.swing.JPanel;
import java.awt.event.*;
import java.awt.event.MouseAdapter;
import java.awt.*;

public class MouseListener extends MouseAdapter {
   private MyWorld world;
   private Drawable currentElement;
   private JPanel panel;
   public MouseListener (MyWorld w, JPanel p){
      world = w;
      panel = p;
   } 
   public void mouseMoved(MouseEvent e) { //Metodo para pintar de otro color
       //elemento cuando el mouse este sobre una componente (sin apretar nada)
      //Obtiene elemento el cual está bajo el mouse
       Drawable newElement = world.find(e.getX(), e.getY());
      if (newElement == currentElement) return;

       //Si el mouse ya no está sobre la componente registrada
       //Liberarla
      if (currentElement != null) {
         currentElement.setReleased();
         currentElement = null;
      }

       //Si ahora el mouse está sobre una componente, seleccionarla
      if (newElement != null) { 
         currentElement = newElement;
         currentElement.setSelected();
      }

       //No olvidar repintar al terminar
      panel.repaint();
   }
   public void mouseDragged(MouseEvent e) {
      if (currentElement == null) return;
      currentElement.dragTo(e.getX(), e.getY());
      panel.repaint();
   }
   public void mouseReleased(MouseEvent e) {

      if (currentElement != null) 
         currentElement.setReleased();

      //Necesitamos que lo siguiente funcione para GSpring y Rubber
      //Como ambos son hijos de Spring, se opta por esperar Spring y luego separar
      //el comportamiento
      if (!(currentElement instanceof /*GSpring*/ Spring)) {
         currentElement = null;
         return;
      }
          // we dragged an attachable element
          // we dragged a spring, so we look for and attachable element near by  
      AttachableElement element = world.findAttachableElement(e.getX(), e.getY());
      if (element == null) {
         currentElement = null;
         return;
      }
      // we dragged a spring and it is near an attachable element,
      // so we hook them to the right spring end.
      if(currentElement instanceof GSpring){
        GSpring spring = (GSpring) currentElement;
        Vector2D a=spring.getAendPosition();
        if ((a.getX()==e.getX()) && (a.getY()==e.getY()))
            spring.attachAend(element);
        Vector2D b=spring.getBendPosition();
        if ((b.getX()==e.getX()) && (b.getY()==e.getY()))
             spring.attachBend(element);
       }

      //We add compatibility to GRubber
      if(currentElement instanceof GRubber){
          GRubber rubber = (GRubber) currentElement;
          Vector2D a=rubber.getAendPosition();
      if ((a.getX()==e.getX()) && (a.getY()==e.getY()))
         rubber.attachAend(element);
      Vector2D b=rubber.getBendPosition();
      if ((b.getX()==e.getX()) && (b.getY()==e.getY()))
         rubber.attachBend(element);
      }

      currentElement = null;
      panel.repaint();      
   }

   //TODO: OK here i should add the Delete listener (mouse Clicked)
   public void mouseClicked(MouseEvent e){
       //Here delete the component
       
       //if Delete is enabled.. we delete..
       if(world.isDeleteEnabled() == true) {
       
       //I first need to know wich component was clicked
       PhysicsElement newElement = (PhysicsElement) world.find(e.getX(), e.getY());
       world.deleteElement(newElement);

       //Se opta por que cuando se elimine una componente, se deshabilite el eliminar
       world.setDeleteDisabled();
       panel.repaint();

       //Only one action per click
       return;
       }

       //ESTO ES POR 5 PUNTOS ADICIONALES
       //EDITAR PARAMETROS
       //si esta activo Edit Parameters.. se necesita editarlos
       if(world.isEditParametersEnabled() == true){

           //First.. know wich component was clicked
           PhysicsElement newElement = (PhysicsElement) world.find(e.getX(), e.getY());

           //We ask him to display his own edit parameters dialog
           newElement.editParameter();

           //And disable the Edit (only one edit per click)
           world.setEditParametersDisabled();
       }
   }
}