
import java.awt.geom.*;
import java.awt.*;
import javax.swing.JOptionPane;
/**
 *
 * @author hev
 * Clase que permite la representación gráfica de los elasticos
 */
public class GRubber extends Rubber implements Drawable{

    //extremos bien definidos cuando no está conectado
    /**
     * Posición del extremo del elastico cuando no tiene nada enganchado a el
     */
    private Vector2D freeAendPosition;
    /**
     * Posición del extremo del elastico cuando no tiene nada enganchado a el
     */
    private Vector2D freeBendPosition;
    /**
     * Contiene la representación gráfica del elástico
     */
    private Line2D.Double shape;
    /**
     * Stroke para cambiar valores de grosor del elastico
     */
    private Stroke stroke;

    /**
     * Constructor
     * @param restLength    Largo en reposo
     * @param stiffness     Constante elastica
     */
    public GRubber(float restLength, float stiffness){
        super(restLength, stiffness);
        freeAendPosition = new Vector2D(0,0);
        freeBendPosition = new Vector2D(restLength, restLength);
        shape = new Line2D.Double(getAendPosition().getX(),getAendPosition().getY(),
                getBendPosition().getX(), getBendPosition().getY());

        stroke = new BasicStroke(2);
    }

    /**
     * Obtener la posicion del extremo A
     * @return La posicion del objeto al que esta atado el extremo, o si no existe, freeAendPosition
     */
   public Vector2D getAendPosition() {
      if (a_end == null)
         return freeAendPosition;
      return super.getAendPosition();
   }

       /**
     * Obtener la posicion del extremo B
     * @return La posicion del objeto al que esta atado el extremo, o si no existe, freeBendPosition
     */
   public Vector2D getBendPosition() {
      if (b_end == null)
         return freeBendPosition;
      return super.getBendPosition();
   }

   /**
    * Metodo para dibujar el elastico <br/>
    * El elastico se pinta rojo si esta estirado y negro si no lo esta <br/>
    * Este metodo esta encargado de escribir a un lado la constante elastica
    * @param g  Graphics2D.. contiene información del objeto a quien dibujar
    */
    public void draw (Graphics2D g){

        //Por ahora solo se dibuja una linea recta
        //TODO.. si el stretch es menor al restLength hacer q elastico se grafique compacto
        Vector2D v = getVector();

        if(v.module() < restLength)
            g.setColor(Color.black);
        
        if(v.module() >= restLength)
            g.setColor(Color.red);

        shape = new Line2D.Double(getAendPosition().getX(), getAendPosition().getY(),
                getBendPosition().getX(), getBendPosition().getY());

        g.setStroke(stroke);
        g.draw(shape);

      //Aca van los pasos para escribir la constante elastica del resorte
      g.setColor(Color.BLUE);
      g.drawString("stiffness: " +Float.toString(getStiffness()),
              (float)shape.getBounds2D().getCenterX(),
              (float) shape.getBounds2D().getCenterY());

    }

    /**
     * Metodo para saber si el punto X,Y estan contenidos dentro del objeto
     * @param x     coordenada X
     * @param y     coordenada Y
     * @return      TRUE si las coordenadas son parte del objeto, false si no lo son
     */
    public boolean contains(int x, int y){
      return shape.getBounds2D().contains(x,y);
   }


    //Metodo ve que extremo esta mas cerca del punto de Drag (donde esta el mouse ahora)
    //Y suelta al mas cercano para que lo podamos arrastrar
    /**
     * Metodo para arrastrar el resorte
     * @param x     Nueva posicion del resorte, eje X
     * @param y     Nueva posicion del resorte, eje Y
     */
      public void dragTo(int x, int y){
      Vector2D a=getAendPosition();
      Vector2D b=getBendPosition();
      double da = Math.abs(a.getX()-x)+Math.abs(a.getY()-y); // "distance" to a
      double db = Math.abs(b.getX()-x)+Math.abs(b.getY()-y); // "distance" to a
      if (da < db) {
         detachAend();
         freeAendPosition.set(x,y);
      }
      else {
         detachBend();
         freeBendPosition.set(x,y);
      }
   }

      //Se pinta el elastico más grueso si el mouse lo selecciona
      /**
       * Pintar mas grueso el elastico si el mouse esta sobre el
       */
   public void setSelected() {
      stroke = new BasicStroke(4);
   }

   /**
    * Pintar normal elastico si mouse deja de estar sobre el
    */
   public void setReleased() {
      stroke = new BasicStroke(2);
   }

   /**
    * Setear los nuevos valores freeBendPosition y freeAendPosition
    */
   public void updateState(){  // just to return to a rest length
      if (a_end==null && b_end==null) return;  // when it is released
      if (a_end!=null) {
         Vector2D v = getVector().unitary().times(restLength);
         freeBendPosition = getAendPosition().plus(v);
         return;
      }
      if (b_end!=null) {
         Vector2D v = getVector().unitary().times(restLength);
         freeAendPosition = getBendPosition().minus(v);
         return;
      }
   }

    //POR LOS 5 PUNTOS
    //EDITAR PARAMETRO
    /**
     * <BIG>Esto es parte del desarrollo para los 5 puntos extra:</BIG>
     * Metodo para cambiar el valor de la constante elastica
     */
    public void editParameter(){

       String newStiffness = JOptionPane.showInputDialog("Por favor ingrese nueva"
               + "constante elastica");
       setStiffness(Float.parseFloat(newStiffness));
   }

}
