import java.awt.*;
import java.awt.geom.*;
class GFixedHook extends FixedHook implements Drawable {
   private float width;
   private Color color = Color.GREEN;
   private Rectangle2D.Float shape = null;
   public GFixedHook (Vector2D pos, float w) {
      super(pos);
      width = w;
      shape = new Rectangle2D.Float((float)pos.getX()-w/2, (float)pos.getY()-w/2,w,w);
   }
   public void draw (Graphics2D g){
      shape.setFrame((float)getX()-width/2, (float)getY()-width/2, width, width);
      g.setColor(color);
      g.fill(shape);
   }
   public boolean contains (int x, int y){
      return shape.contains(x,y);
   }
   public void dragTo(int x, int y){
      setPosition(x,y);
   }
   public void setSelected(){
      color = Color.RED;
   }
   public void setReleased() {
      color = Color.GREEN;
   }
}