import java.awt.*;
import java.awt.geom.*;
import javax.swing.JOptionPane;
class GBall extends Ball implements Drawable {
   private float radius;
   private Color color = Color.BLUE;
   private Ellipse2D.Float shape = null;
   public GBall (float mass, Vector2D position, Vector2D speed, 
                  float radius){
      super(mass, position, speed);
      this.radius = radius;
      setCrossSection(6*Math.PI*radius);
      shape = new Ellipse2D.Float((float)getX()-radius, (float)getY()-radius, 2*radius, 2*radius);
   }
   public void draw (Graphics2D g){
      shape.setFrame((float)getX()-radius, (float)getY()-radius, 2*radius, 2*radius);
      g.setColor(color);
      g.fill(shape);

      //Pasos para poner el valor de la masa de la pelota dentro de ella
      g.setColor(Color.WHITE);
      g.drawString(Float.toString(getMass()), (float)(shape.getCenterX()- radius),
              (float)shape.getCenterY() + radius/4);
   }
   public boolean contains (int x, int y){
      return shape.contains(x,y);
   }
   public void dragTo(int x, int y){
      setPosition(x,y);
   }
   public void setSelected (){
      color = Color.RED;
   }
   public void setReleased() {
      color = Color.BLUE;
   }

    @Override
   public void editParameter(){

        //Se setea la masa usando un Dialogo
        String mass = JOptionPane.showInputDialog("Por favor ingrese el valor "
                + "de la nueva Masa");
        setMass(Float.parseFloat(mass));
   }
}