import java.util.*;

public class FixedHook extends AttachableElement {
   private static int id=0;
   private Vector2D pos_t;     // current position at time t
   private Vector<Spring> springs;  // Vector can grow, arrays cannot. 
   
   private FixedHook(){   // nobody can create a block without state
     super(id++);
   }
   public FixedHook(Vector2D pos){
      super(id++);
      pos_t = pos;
      springs = new Vector<Spring>();
   }
   public void attachSpring (Spring spring) {
     springs.add(spring);
   }
   public void detachSpring (Spring spring) {
     springs.remove(spring);
   }
   public Vector2D getPosition() {
      return pos_t;
   }
   public double getX() {
      return pos_t.getX();
   }
   public double getY() {
      return pos_t.getY();
   }
   public void setPosition(int x, int y){
      pos_t.set(x,y);
   }
   public String getDescription() {
      return "FixedHook_" + getId()+":"+pos_t.getDescription();
   }
   public String getState() {
      return getPosition()+"";
   }

}
