import java.awt.event.*;
import javax.swing.JMenuItem;

public class ConfigurationMenuListener implements ActionListener {
   private MyWorld  world;
   public ConfigurationMenuListener (MyWorld  w){
      world = w;
   }
   public void actionPerformed(ActionEvent e) {
      JMenuItem menuItem = (JMenuItem)(e.getSource());
      String text = menuItem.getText();
      if (text.equals("Ball")) 
         world.addElement(new GBall(10f, new Vector2D(200f,200f), new Vector2D(), 15f));
      if (text.equals("Fixed Hook")) 
         world.addElement(new GFixedHook(new Vector2D(200f,100f), 30f));
      if (text.equals("Spring")) 
         world.addElement(new GSpring (200f, 10f));

      //Add the new Rubber
      if (text.equals("Rubber"))
          world.addElement(new GRubber(200f, 10f));

      //Delete action
      if (text.equals("Delete")){          
          //IDEA: give the setDeleteEnabled to myWorld.. so he can save it
          //And the mouse listener use this info to set the X on the cursor
          world.setDeleteEnabled();
          //Cambiar puntero mouse (se hace en my World)
      }

      //Configure parameters
      if (text.equals("Edit Parameters")){

          //Se setea variable edit parameters (en my world) a true..
          //Luego se captura con el mouse listener
          world.setEditParametersEnabled();
      }
   }
}