import java.util.*;

public class Ball extends AttachableElement  {
   private static int id=0;  // Ball identification number
   private double crossSection;
   //!!! IMPORTANTE.. se cambia variable mass (se le quita final)
   //ahora se puede modificar
   private float mass;
   private Vector2D pos_t;     // current position at time t
   private Vector2D pos_tPlusDelta;  // next position in delta time in future
   private Vector2D speed_t;   // speed at time t
   private Vector2D speed_tPlusDelta;   // speed in delta time in future
   private Vector2D a_t;    // acceleration at time t
   private Vector2D a_tMinusDelta;  // acceleration delta time ago;
   private Vector<Spring> springs;  // Vector can grow, arrays cannot. 
   
   private Ball(){   // nobody can create a block without state
     super(id++);
     mass=0;
   }
   public Ball(float mass, Vector2D position, Vector2D speed){
      super(id++);
      this.mass = mass;
      pos_t = position;
      speed_t = speed;
      a_t = new Vector2D();
      a_tMinusDelta = new Vector2D();
      springs = new Vector<Spring>();
      crossSection = 1.0f;
   }
   public void attachSpring (Spring spring) {
     springs.add(spring);
   }
   public void detachSpring (Spring spring) {
     springs.remove(spring);
   }
   public Vector2D getPosition() {
      return pos_t;
   }
   public double getX() {
      return pos_t.getX();
   }
   public double getY() {
      return pos_t.getY();
   }
   public void setPosition(int x, int y){
      pos_t.set(x,y);
   }
   public void setCrossSection(double cs) {
      crossSection = cs;
   }
   private Vector2D getNetForce(Vector2D g, float viscosity ) {
     Vector2D force = new Vector2D();
     for (Spring s: springs)
        force = force.plus(s.getForce(this));
     force = force.plus(g.times(mass));
     force = force.minus(speed_t.times(viscosity*crossSection)); 
     return(force);    
   }
   public void setInitialState(Vector2D g, float viscosity) {
      a_tMinusDelta = getNetForce(g, viscosity).times(1/mass);
   }
   public void computeNextState(double delta_t, Vector2D g, float viscosity) {
     a_t = getNetForce(g, viscosity).times(1/mass);
     speed_tPlusDelta = speed_t.plus(a_t.times(3).minus(a_tMinusDelta).times(delta_t/2));
     pos_tPlusDelta = pos_t.plus(speed_t.times(delta_t)).plus(a_t.times(4).minus(a_tMinusDelta).times(delta_t*delta_t/6));
   }
   public void updateState(){
     pos_t = pos_tPlusDelta;
     speed_t = speed_tPlusDelta;
     a_tMinusDelta = a_t;
   }
   public String getDescription() {
      return "Ball_" + getId()+":"+Vector2D.getDescription();
   }
   public String getState() {
      return getPosition()+"";
   }

   //Se agrega metodo para setear velocidades y aceleraciones a cero
   public void resetVelocityAndAcceleration(){
       this.speed_t = new Vector2D(0,0);
       this.speed_tPlusDelta = new Vector2D(0,0);
       this.a_tMinusDelta = new Vector2D(0,0);
       this.a_t = new Vector2D(0,0);
   }

   //Metodo para obtener la masa (para que GBall pueda imprimirla)

   public float getMass(){
       return mass;
   }

   //Metodo para setear Masa (para 5 puntos extras)
   public void setMass(float newMass){
       mass = newMass;
   }

}
