import java.awt.*;
import java.io.*;
import java.awt.event.*;
import javax.swing.*;
import java.util.*;

/**
 * Clase para generar los paneles dentro del frame que controla el aspecto grafico
 * @author Eduardo Garcia y Sebastian Contreras
 */
public class SplitJFrame extends JFrame implements ActionListener{
    
    //evita un error de codigo que aun no entendemos.
    private static final long serialVersionUID = 2284811612927213785L;
    
/**
 * Constructor para SplitJFrame, para generar el frame de la tarea con su respectivo menu
 * con titulo Tarea 2: Tombola 
 */    
    public SplitJFrame(){
                setTitle("Tarea 2: Tombola");
		setSize(900, 700);
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
                
                JMenu fileMenu = new JMenu("Archivo");
		addItem(fileMenu,"Abrir",1);
		addItem(fileMenu,"Terminar",2);

		JMenu actionMenu = new JMenu("Accion");
		addItem(actionMenu,"Rodar", 3);
		addItem(actionMenu,"Buscar",4);

		JMenu aboutMenu = new JMenu("Acerca");
		addItem(aboutMenu,"Acerca de...", 5);

		JMenuBar menuBar = new JMenuBar();
		setJMenuBar(menuBar);

		menuBar.add(fileMenu);
		menuBar.add(actionMenu);
		menuBar.add(aboutMenu);
                
                panel.setLayout(new GridLayout(1, 2));
		panel.add(new JScrollPane(normal));
		panel.add(new JScrollPane(aleatorio));
		add(panel);
                
                setLocationRelativeTo(null); 
		setVisible(true);
    }

/**
 * Metodo para insertar items en el menubar
 * @param menu Nombre del menu en el cual se insertara un elemento
 * @param label Nombre del elemento a insertar en el menu
 * @param cod_action numero identificador de accion
 */    
    void addItem(JMenu menu, String label, int cod_action){		
		JMenuItem abrirItem = new JMenuItem(label);
		abrirItem.setActionCommand(Integer.toString(cod_action));
		abrirItem.addActionListener(this);	
		menu.add(abrirItem);
    }
    
/**
 * Metodo para la implementacion de los diversos eventos del menu
 * @param e Evento de accion disparado en el menu segun codigo de accion:
 * 1 Abrir un fichero
 * 2 Terminar aplicacion
 * 3 Reordenar aleatoriamente la lista
 * 4 Buscar personas dentro de la lista
 * 5 Informacion de los desarrolladores
 */    
    public void actionPerformed(ActionEvent e) {    
        LeeFichero lector = new LeeFichero();
        int cod_action =  Integer.parseInt(e.getActionCommand());

		switch(cod_action){
                
                case 1:
			final int retval = eligefichero.showOpenDialog(this);
			if (retval == JFileChooser.APPROVE_OPTION) {
				File file = eligefichero.getSelectedFile();
				this.fichero = file.getAbsolutePath();
				normal.limpiar();
				normal.addArrayElements(lector.Lector(this.fichero));
                                aux = lector.getNumLin(fichero);
				panel.revalidate();
			}
			break;

		case 2:		
			System.exit(0);
			break;

		case 3:	
			aleatorio.limpiar();
			BubbleSorter bubble_sorter = new BubbleSorter();
			Estudiante[] estudiantes_aleatorio = lector.Lector(fichero);
			bubble_sorter.ordenar(estudiantes_aleatorio);
			aleatorio.addArrayElements(estudiantes_aleatorio);
			panel.revalidate();
			break;

		case 4:	
			if(fichero!= null){
				Estudiante[] estudiantes = lector.Lector(fichero);
				LinearSearcher buscador = new LinearSearcher();
				String str = JOptionPane.showInputDialog(null, "Ingrese el nombre o apellido", "Busqueda", 1);
				if(str != null ){
                                    coincidencias = buscador.match(estudiantes, str);                                    
                                    normal.setSelectedIndices(coincidencias);
                                }
			}
			break;

		case 5:		
			new JAcerca(this);
			break;
		}
    }               
	int aux;
        int[] coincidencias;
        JFileChooser eligefichero = new JFileChooser();        
        JPanel panel = new JPanel();
        JListVar normal = new JListVar();
	JListVar aleatorio = new JListVar();
        String fichero = null;

}
