import java.io.*;
import java.util.*;

/**
 * Clase para leer desde el contenido de un archivo especificado
 * @author Eduardo Garcia y Sebastian Contreras
 */

public class LeeFichero {
    
/**
 * Constructor de LeeFichero
 */    
   public LeeFichero(){}
    
/**
 * Metodo para leer un archivo especificado, teniendo en consideracion las posibles excepciones
 * @param fichero String con el nombre especifico del fichero a leer
 * @return Arreglo de Estudiantes del fichero especificado
 */    
    public Estudiante[] Lector(String fichero){		//
		int num_lin = getNumLin(fichero);

		Estudiante[] students = new Estudiante[num_lin];


		try {
			FileInputStream fstream = new FileInputStream(fichero);
			DataInputStream in = new DataInputStream(fstream);
			BufferedReader br = new BufferedReader(new InputStreamReader(in));
			String strLine;

			int i = 0;
			while ((strLine = br.readLine()) != null)   {
				students[i] = new Estudiante(strLine,(int)(Math.random()*45+55));
				System.out.println(students[i] );
				i++;
			}

			in.close();
		} catch (FileNotFoundException e) {
			System.err.println("El sistema no puede hallar el archivo especificado" + fichero);
			e.printStackTrace();
			System.exit(0);

		} catch (IOException e) {
			System.err.println("El archivo no existe o no se puede leer " + fichero);
			e.printStackTrace();
			System.exit(0);
		}

		return students;
	}	
	
/** Metodo para obtener el numero de lineas que tiene el ficheroespecificado,considerando sus excepciones
 * @return Numero de lineas del fichero especificado
 */
	int getNumLin(String archivo){
		int num_lin = 0;
		try {
			FileInputStream fstream = new FileInputStream(archivo);
			DataInputStream in = new DataInputStream(fstream);
			BufferedReader br = new BufferedReader(new InputStreamReader(in));


			while ((br.readLine()) != null)   {
				num_lin++;
			}

			in.close();
		} catch (FileNotFoundException e) {
			System.err.println("El archivo no existe o no se puede leer " + archivo );
			e.printStackTrace();
			System.exit(0);

		} catch (IOException e) {
			System.err.println("El archivo no existe o no se puede leer " + archivo);
			e.printStackTrace();
			System.exit(0);
		}

		return num_lin;
	}       
}
