import javax.swing.DefaultListModel;
import javax.swing.JList;

/**
 * Clase para manejo de listas de objetos, en este caso los nombres que se mostraran en los paneles 
 * @author Eduardo Garcia y Sebastian Contreras
 */

public class JListVar extends JList 
{    
	private static final long serialVersionUID = 1L;

/**
 * Constructor de JListVar 
 */
	public JListVar() 
    {	
            super(new DefaultListModel());
    }

/**
 * Metodo para obtener contenidos de una lista
 * @return Contenido de la lista
 */
    public DefaultListModel getContents()
    {
           return (DefaultListModel)getModel();
    }
    
/**
 * Metodo para insertar un elemento en una lista
 * @param obj Objeto a insertar en la lista
 */    
    public void addElement(Object obj){
    	getContents().addElement(obj);
    }
    
/**
 * Metodo para insertar un arreglo de elementos en una lista
 * @param obj Arreglo de objetos para insertar en la lista
 */   
    public void addArrayElements(Object[] obj)
    {
    	for(int i = 0; i < obj.length ; i++)
    		addElement(obj[i]);
    }    
    
/**
 * Metodo para vaciar el contenido de una lista
 */    
    public void limpiar(){
    	getContents().removeAllElements();
    }   
}
    
