/**
 * Clase para implementacion de estudiantes.
 * @author Sebastian Contreras, Eduardo Garcia.
 */
import java.util.*;
import java.math.*;

public class Estudiante extends Persona implements Comparable<Estudiante>
{    
/**
 * Constructor de estudiantes.
 * @param nombre del estudiante
 * @param promedioPonderado del estudiante
 */
    public Estudiante(String nombre, int promedioPonderado) 
    {
        super(nombre);
        pp = promedioPonderado;     
    }
/**
 * Metodo para obtener promedio ponderado.
 * @return promedio ponderado del estudiante
 */
    public int getpromedioPonderado() 
    {
        return pp;
    }  
    @Override
    public String toString(){
		return   super.getName();
    }
    private int pp;
/**
 * Metodo para realizar las comparaciones de los algoritmos de ordenamiento.
 * @param otro estudiante para ser comparado por promedio ponderado.
 * @return -1, 1 o 0 en caso de ser menor, mayor o igual, respectivamente, los promedios a comparar.
 */

    @SuppressWarnings("static-access")
    public int compareTo(Estudiante otro) 
    {        
        if (!(otro instanceof Estudiante))
            throw new ClassCastException("A Estudiante object expected");
        else
            if (getpromedioPonderado() < otro.getpromedioPonderado())
		  return -1;
            else             
                if(getpromedioPonderado() > otro.getpromedioPonderado())
                    return 1;
                else
                    return 0;
            
        
    }
}
