
import java.util.*;
import java.util.regex.*;

/**
 * Superclase para distintas implementaciones de algoritmos de busqueda.
 * @author Sebastian Contreras, Eduardo Garcia.
 */
public abstract class Buscador
{
/** 
 * Busca un alumno en una lista de objetos.
 * @param A Arreglo de Objetos
 * @param obj Objeto Alumno
 * @return retorna el indice del arreglo que contiene el objeto o -1 en caso de no encontrarlo.
 */
 public abstract int[] buscar(Object [] A, Object obj);

/** 
 * Retorna el numero de comparaciones efectuadas para dar con el objeto o concluir que no esta.
 * @return numero de comparaciones hechas para ordenar el arreglo
 */
  public abstract int getNumComparaciones();
  
  
  // esta funcion soluciona el problema de las mayusculas y minusculas para la busqueda de nombres
  /**
   * @param A Arreglo de Objetos para buscar un calce
   * @param palabra String que se desea encontrar
   * @return El entero que indica el numero de posicion donde se encuentra el o los calces deseados de persona buscada, teniendo en cuenta la diferencia entre mayuscula y minuscula
   */
  
  public int[] match(Object[] A, String palabra) {
		int retorno[] = {-1};
		palabra = palabra.toUpperCase();
		ArrayList<Integer> indices = new ArrayList<Integer>();

		for(int i = 0; i < A.length; i++){
			Pattern  pattern = Pattern.compile(palabra.toUpperCase());
			Matcher matcher = pattern.matcher(A[i].toString().toUpperCase());
			if (matcher.find()){
				indices.add(i);
			}
		}

		if(indices.size()>0 ){
			retorno = new int[indices.size()]; 
			for(int i = 0; i< indices.size(); i++)
				retorno[i] = Integer.parseInt(indices.get(i).toString());
			
		}

		return retorno;
	}

}
