
/**
 * @author tavo
 *
 * 
 *
 */
class Vector {
	
	/**
	 * Representa un vector mediante sus coordenadas cartesianas en 2 dimensiones.
	 * 
	 * @param x Valor de la componente x del punto que representa al Vector.  
	 * @param y Valor de la componente y del punto que representa al Vector.
	 */
	private double x , y;
	
	/**
	 * Retorna componente x del vector.
	 * @return componente x del vector.
	 */
	public double getX() {
		return x;
	}
	/**
	 * Retorna componente y del vector.
	 * @return comoponente y del vector.
	 */
	public double getY() {
		return y;
	}
	
	
	/**
	 * Cambia el valor de x por el argumento (double) pasado 
	 * como par?metro
	 * @param x Valor que se asigna a componte x del vector. 
	 */
	public void setX(double x) {
		this.x = x;
	}
	
	/**
	 * Cambia el valor de y por el argumento (double) pasado 
	 * como par?metro
	 * @param y Valor que se asigna a componte y del vector.
	 * 
	 */ 
	public void setY(double y) {
		this.y = y;
	}
	
	
	/** 
	 * Crea un vector a partir de sus componentes cartesianas en 2 dimesiones.
	 * 
	 * @param x Valor de la componente x del punto que representa al Vector.
	 * @param y Valor de la componente y del punto que representa al Vector.
	 */
	Vector(double x, double y) {
		this.x = x;
		this.y = y;
	}
	/**
	 * Crea un vector a partir de sus coordenadas polares.
	 * 
	 * @param r Radio del vector en coordenadas polares.
	 * @param alpha ?ngulo del vector en coordenadas polares. 
	 * Se representa en radianes.
	 */
	Vector(float r, double alpha) {
		this.x = r * (float) Math.cos(alpha);
		this.y = r * (float) Math.sin(alpha);
	}
	/**
	 * Suma al vector original otro vector dado como argumento.
	 * @param v vector que se le suma.
	 */
	public  void sumarle(Vector v) {
		this.x = (this.x + v.x);
		this.y = (this.y + v.y);
	}
	/**
	 * multiplica por un escalar dado  como argumento.
	 * 
	 * @param m escalar por el cual se multiplica al Vector.
	 */
	public void multiplicacionPorEscarlar(float m) {
		System.out.println(m);
		System.out.println((double) m);
		x =  x *  m; 
		y =  y *  m;
		
	}
	
	/**
	 * rota en alfa radianes.
	 * @param alfa Angulo de rotaci?n del Vector.
	 */
	public void rotar(float alfa) {
		x = Math.sqrt(x * x + y * y) * Math.cos(Math.atan2(y , x)  + alfa);
		y = Math.sqrt(x * x + y * y) * Math.sin(Math.atan2(y , x)  + alfa);
	}
	
	/**
	 * convierte en  String sus componentes x e y.
	 * @return stringSalida String que representa al vector. Indica
	 * sus componentes x e y.
	 * 
	 */
	public String toString() {
		String stringSalida = "(" + x + ", " + y + ")";
		return (stringSalida); 
	} 
	
	/**
	 * indica si un Vector tiene igual estado que otro. Es decir,
	 * si sus componentes x e y son iguales.  
	 * @param v Vector con el que se compara.
	 * @return salida Retorna verdadero si sus componentes x e y
	 * son iguales al vector con el que se le comparo.
	 * Falso en caso contrario 
	 */
	public boolean equals(Vector v) {
		boolean salida = (this.x == v.x && this.y == v.y);
		return (salida);
	}
	

	/**
	 * Suma dos vectores
	 * @param a vector 1
	 * @param b vector 2
	 * @return  suma de los dos vectores
	 */	
	public static Vector suma(Vector a, Vector b) {
		Vector resultadoSuma = new Vector(a.x + b.x, a.y + b.y);
		return (resultadoSuma);
	}
	/**
	 * Resta dos vectores
	 * 
	 * @param a vector1
	 * @param b vector2, se le resta al vector1
	 * @return vector1 - vector2
	 */
	
	public static Vector resta(Vector a, Vector b) {
		Vector vectorresta = new Vector(a.x - b.x, a.y - b.y);
		return (vectorresta);
	}
	
	/**
	 * Producto Punto de 2 Vectores 
	 * 
	 * @param a Vector 1 
	 * @param b Vector 2
	 * @return  Producto punto de Vector1 y Vector2.
	 */
	public static float productoPunto(Vector a , Vector b) { 
		float salidafloat = (float) (a.x * b.x + a.y * b.y);
		return (salidafloat);
	}
	
	
}
