/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.pde.api.tools.internal.IApiXmlConstants;
import org.eclipse.pde.api.tools.internal.problems.ApiProblemFactory;
import org.eclipse.pde.api.tools.internal.problems.ApiProblemFilter;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.IApiFilterStore;
import org.eclipse.pde.api.tools.internal.provisional.problems.IApiProblem;
import org.eclipse.pde.api.tools.internal.provisional.problems.IApiProblemFilter;
import org.eclipse.pde.api.tools.internal.util.Util;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ApiFilterStore
implements IApiFilterStore,
IResourceChangeListener {
    private static final String SETTINGS_FOLDER = ".settings";
    public static final String GLOBAL = "!global!";
    public static final int CURRENT_STORE_VERSION = 2;
    private static IApiProblemFilter[] NO_FILTERS = new IApiProblemFilter[0];
    private HashMap fFilterMap = null;
    private HashMap fUnusedFilters = null;
    IJavaProject fProject = null;
    boolean fNeedsSaving = false;
    boolean fTriggeredChange = false;

    public ApiFilterStore(IJavaProject project) {
        Assert.isNotNull((Object)project);
        this.fProject = project;
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    public void persistApiFilters() {
        if (!this.fNeedsSaving) {
            return;
        }
        final HashMap filters = new HashMap(this.fFilterMap);
        WorkspaceJob job = new WorkspaceJob(""){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                if (ApiPlugin.DEBUG_FILTER_STORE) {
                    System.out.println("persisting api filters for plugin project component [" + ApiFilterStore.this.fProject.getElementName() + "]");
                }
                try {
                    InputStream xstream;
                    SubMonitor localmonitor = SubMonitor.convert((IProgressMonitor)monitor);
                    IProject project = ApiFilterStore.this.fProject.getProject();
                    if (!project.isAccessible()) {
                        if (ApiPlugin.DEBUG_FILTER_STORE) {
                            System.out.println("project [" + ApiFilterStore.this.fProject.getElementName() + "] is not accessible, saving terminated");
                        }
                        return Status.CANCEL_STATUS;
                    }
                    String xml = ApiFilterStore.this.getStoreAsXml(filters);
                    IFile file = project.getFile(ApiFilterStore.this.getFilterFilePath(false));
                    if (xml == null) {
                        if (ApiPlugin.DEBUG_FILTER_STORE) {
                            System.out.println("no XML to persist for plugin project component [" + ApiFilterStore.this.fProject.getElementName() + "]");
                        }
                        if (file.isAccessible()) {
                            IFolder folder = (IFolder)file.getParent();
                            file.delete(true, (IProgressMonitor)localmonitor);
                            if (folder.members().length == 0 && folder.isAccessible()) {
                                folder.delete(true, (IProgressMonitor)localmonitor);
                            }
                            ApiFilterStore.this.fTriggeredChange = true;
                        }
                        return Status.OK_STATUS;
                    }
                    String lineDelimiter = ApiFilterStore.getLineDelimiterPreference(file);
                    String lineSeparator = System.getProperty("line.separator");
                    if (lineDelimiter != null && !lineDelimiter.equals(lineSeparator)) {
                        xml = xml.replaceAll(lineSeparator, lineDelimiter);
                    }
                    if ((xstream = Util.getInputStreamFromString(xml)) == null) {
                        return Status.CANCEL_STATUS;
                    }
                    try {
                        if (file.getProject().isAccessible()) {
                            if (!file.exists()) {
                                IFolder folder = (IFolder)file.getParent();
                                if (!folder.exists()) {
                                    folder.create(true, true, (IProgressMonitor)localmonitor);
                                }
                                file.create(xstream, true, (IProgressMonitor)localmonitor);
                            } else {
                                file.setContents(xstream, true, false, (IProgressMonitor)localmonitor);
                            }
                        }
                    }
                    finally {
                        xstream.close();
                    }
                    ApiFilterStore.this.fTriggeredChange = true;
                    ApiFilterStore.this.fNeedsSaving = false;
                }
                catch (CoreException ce) {
                    ApiPlugin.log(ce);
                }
                catch (IOException ioe) {
                    ApiPlugin.log(ioe);
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.setPriority(10);
        job.schedule();
    }

    public synchronized void addFilters(IApiProblemFilter[] filters) {
        if (filters == null) {
            if (ApiPlugin.DEBUG_FILTER_STORE) {
                System.out.println("null filters array, not adding filters");
            }
            return;
        }
        this.initializeApiFilters();
        int i = 0;
        while (i < filters.length) {
            IResource resource;
            IApiProblem problem = filters[i].getUnderlyingProblem();
            String resourcePath = problem.getResourcePath();
            if (resourcePath != null && (resource = this.fProject.getProject().findMember((IPath)new Path(resourcePath))) != null) {
                HashMap pTypeNames = (HashMap)this.fFilterMap.get(resource);
                String typeName = problem.getTypeName();
                if (typeName == null) {
                    typeName = GLOBAL;
                }
                HashSet<IApiProblemFilter> pfilters = null;
                if (pTypeNames == null) {
                    pTypeNames = new HashMap();
                    pfilters = new HashSet<IApiProblemFilter>();
                    pTypeNames.put(typeName, pfilters);
                    this.fFilterMap.put(resource, pTypeNames);
                } else {
                    pfilters = (HashSet<IApiProblemFilter>)pTypeNames.get(typeName);
                    if (pfilters == null) {
                        pfilters = new HashSet();
                        pTypeNames.put(typeName, pfilters);
                    }
                }
                this.fNeedsSaving |= pfilters.add(filters[i]);
            }
            ++i;
        }
        this.persistApiFilters();
    }

    public synchronized void addFiltersFor(IApiProblem[] problems) {
        if (problems == null) {
            if (ApiPlugin.DEBUG_FILTER_STORE) {
                System.out.println("null problems array: not addding filters");
            }
            return;
        }
        if (problems.length < 1) {
            if (ApiPlugin.DEBUG_FILTER_STORE) {
                System.out.println("empty problem array: not addding filters");
            }
            return;
        }
        this.initializeApiFilters();
        this.internalAddFilters(problems, null, true);
    }

    public synchronized IApiProblemFilter[] getFilters(IResource resource) {
        this.initializeApiFilters();
        Map pTypeNames = (Map)this.fFilterMap.get(resource);
        if (pTypeNames == null) {
            return NO_FILTERS;
        }
        ArrayList allFilters = new ArrayList();
        Iterator iterator = pTypeNames.values().iterator();
        while (iterator.hasNext()) {
            Set values = (Set)iterator.next();
            allFilters.addAll(values);
        }
        return allFilters.toArray(new IApiProblemFilter[allFilters.size()]);
    }

    public synchronized boolean isFiltered(IApiProblem problem) {
        this.initializeApiFilters();
        String resourcePath = problem.getResourcePath();
        if (resourcePath == null) {
            return false;
        }
        IResource resource = this.fProject.getProject().findMember((IPath)new Path(resourcePath));
        if (resource == null) {
            if (ApiPlugin.DEBUG_FILTER_STORE) {
                System.out.println("no resource exists: [" + resourcePath + "]");
            }
            return false;
        }
        IApiProblemFilter[] filters = this.getFilters(resource);
        if (filters == null) {
            if (ApiPlugin.DEBUG_FILTER_STORE) {
                System.out.println("no filters defined for [" + resourcePath + "] return not filtered");
            }
            return false;
        }
        IApiProblemFilter filter = null;
        int i = 0;
        int max = filters.length;
        while (i < max) {
            filter = filters[i];
            if (filter.getUnderlyingProblem().equals(problem)) {
                if (ApiPlugin.DEBUG_FILTER_STORE) {
                    System.out.println("recording filter used: [" + filter.toString() + "]");
                }
                this.recordFilterUsed(resource, filter);
                return true;
            }
            ++i;
        }
        if (ApiPlugin.DEBUG_FILTER_STORE) {
            System.out.println("no filter defined for problem: [" + problem.toString() + "]");
        }
        return false;
    }

    public void dispose() {
        this.persistApiFilters();
        this.clearFilters();
        if (this.fUnusedFilters != null) {
            this.fUnusedFilters.clear();
            this.fUnusedFilters = null;
        }
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
    }

    public synchronized IResource[] getResources() {
        this.initializeApiFilters();
        Set resources = this.fFilterMap.keySet();
        return resources.toArray(new IResource[resources.size()]);
    }

    public synchronized boolean removeFilters(IApiProblemFilter[] filters) {
        if (filters == null) {
            if (ApiPlugin.DEBUG_FILTER_STORE) {
                System.out.println("null filters array, not removing");
            }
            return false;
        }
        if (this.fFilterMap == null) {
            if (ApiPlugin.DEBUG_FILTER_STORE) {
                System.out.println("null filter map, not removing");
            }
            return false;
        }
        boolean success = true;
        int i = 0;
        while (i < filters.length) {
            IApiProblem underlyingProblem = filters[i].getUnderlyingProblem();
            String resourcePath = underlyingProblem.getResourcePath();
            if (resourcePath != null) {
                Map pTypeNames;
                IResource resource = this.fProject.getProject().findMember((IPath)new Path(resourcePath));
                if (resource == null) {
                    resource = this.fProject.getProject().getFile(resourcePath);
                }
                if ((pTypeNames = (Map)this.fFilterMap.get(resource)) != null) {
                    Set pfilters;
                    String typeName = underlyingProblem.getTypeName();
                    if (typeName == null) {
                        typeName = GLOBAL;
                    }
                    if ((pfilters = (Set)pTypeNames.get(typeName)) != null && pfilters.remove(filters[i])) {
                        if (ApiPlugin.DEBUG_FILTER_STORE) {
                            System.out.println("removed filter: [" + filters[i] + "]");
                        }
                        this.fNeedsSaving |= true;
                        success &= true;
                        if (pfilters.isEmpty()) {
                            pTypeNames.remove(typeName);
                            if (pTypeNames.isEmpty()) {
                                success &= this.fFilterMap.remove(resource) != null;
                            }
                        }
                    } else {
                        success &= false;
                    }
                }
            }
            ++i;
        }
        this.persistApiFilters();
        return success;
    }

    synchronized String getStoreAsXml(Map filtermap) throws CoreException {
        if (filtermap == null) {
            if (ApiPlugin.DEBUG_FILTER_STORE) {
                System.out.println("no filter map returning null XML for project [" + this.fProject.getElementName() + "]");
            }
            return null;
        }
        if (filtermap.isEmpty()) {
            if (ApiPlugin.DEBUG_FILTER_STORE) {
                System.out.println("empty filter map returning null XML for project [" + this.fProject.getElementName() + "]");
            }
            return null;
        }
        Document document = Util.newDocument();
        Element root = document.createElement("component");
        document.appendChild(root);
        root.setAttribute("id", this.fProject.getElementName());
        root.setAttribute("version", IApiXmlConstants.API_FILTER_STORE_CURRENT_VERSION);
        Set allFiltersEntrySet = filtermap.entrySet();
        ArrayList allFiltersEntries = new ArrayList(allFiltersEntrySet.size());
        allFiltersEntries.addAll(allFiltersEntrySet);
        Collections.sort(allFiltersEntries, new Comparator(){

            public int compare(Object o1, Object o2) {
                Map.Entry entry1 = (Map.Entry)o1;
                Map.Entry entry2 = (Map.Entry)o2;
                String path1 = ((IResource)entry1.getKey()).getFullPath().toOSString();
                String path2 = ((IResource)entry2.getKey()).getFullPath().toOSString();
                return path1.compareTo(path2);
            }
        });
        Iterator iter = allFiltersEntries.iterator();
        while (iter.hasNext()) {
            Map.Entry allFiltersEntry = (Map.Entry)iter.next();
            IResource resource = (IResource)allFiltersEntry.getKey();
            Map pTypeNames = (Map)allFiltersEntry.getValue();
            if (pTypeNames == null) continue;
            Set allTypeNamesEntriesSet = pTypeNames.entrySet();
            ArrayList allTypeNamesEntries = new ArrayList(allTypeNamesEntriesSet.size());
            allTypeNamesEntries.addAll(allTypeNamesEntriesSet);
            Collections.sort(allTypeNamesEntries, new Comparator(){

                public int compare(Object o1, Object o2) {
                    Map.Entry entry1 = (Map.Entry)o1;
                    Map.Entry entry2 = (Map.Entry)o2;
                    String typeName1 = (String)entry1.getKey();
                    String typeName2 = (String)entry2.getKey();
                    return typeName1.compareTo(typeName2);
                }
            });
            Iterator iterator = allTypeNamesEntries.iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                String typeName = (String)entry.getKey();
                Set filters = (Set)entry.getValue();
                if (filters.isEmpty()) continue;
                Element relement = document.createElement("resource");
                relement.setAttribute("path", resource.getProjectRelativePath().toPortableString());
                boolean typeNameIsInitialized = false;
                if (typeName != GLOBAL) {
                    relement.setAttribute("type", typeName);
                    typeNameIsInitialized = true;
                }
                root.appendChild(relement);
                typeName = null;
                ArrayList filtersList = new ArrayList(filters.size());
                filtersList.addAll(filters);
                Collections.sort(filtersList, new Comparator(){

                    public int compare(Object o1, Object o2) {
                        int problem2Id;
                        IApiProblem p1 = ((IApiProblemFilter)o1).getUnderlyingProblem();
                        IApiProblem p2 = ((IApiProblemFilter)o2).getUnderlyingProblem();
                        int problem1Id = p1.getId();
                        int ids = problem1Id - (problem2Id = p2.getId());
                        if (ids == 0) {
                            String[] args2;
                            String[] args1 = p1.getMessageArguments();
                            int length = args1.length < (args2 = p2.getMessageArguments()).length ? args1.length : args2.length;
                            int i = 0;
                            while (i < length) {
                                int args = args1[i].compareTo(args2[i]);
                                if (args != 0) {
                                    return args;
                                }
                                ++i;
                            }
                            return args1.length - args2.length;
                        }
                        return ids;
                    }
                });
                Iterator iterator2 = filtersList.iterator();
                while (iterator2.hasNext()) {
                    String[] messageArguments;
                    int length;
                    IApiProblemFilter filter = (IApiProblemFilter)iterator2.next();
                    IApiProblem problem = filter.getUnderlyingProblem();
                    typeName = problem.getTypeName();
                    Element filterElement = document.createElement("filter");
                    filterElement.setAttribute("id", Integer.toString(problem.getId()));
                    String comment = filter.getComment();
                    if (comment != null) {
                        filterElement.setAttribute("comment", comment);
                    }
                    if ((length = (messageArguments = problem.getMessageArguments()).length) > 0) {
                        Element messageArgumentsElement = document.createElement("message_arguments");
                        int j = 0;
                        while (j < length) {
                            Element messageArgumentElement = document.createElement("message_argument");
                            messageArgumentElement.setAttribute("value", String.valueOf(messageArguments[j]));
                            messageArgumentsElement.appendChild(messageArgumentElement);
                            ++j;
                        }
                        filterElement.appendChild(messageArgumentsElement);
                    }
                    relement.appendChild(filterElement);
                }
                if (typeName == null || typeNameIsInitialized || typeName.length() == 0) continue;
                relement.setAttribute("type", typeName);
            }
        }
        return Util.serializeDocument(document);
    }

    /*
     * Unable to fully structure code
     */
    private synchronized void initializeApiFilters() {
        block40: {
            if (this.fFilterMap != null) {
                return;
            }
            if (ApiPlugin.DEBUG_FILTER_STORE) {
                System.out.println("initializing api filter map for project [" + this.fProject.getElementName() + "]");
            }
            this.fFilterMap = new HashMap<K, V>(5);
            filepath = this.getFilterFilePath(true);
            file = ResourcesPlugin.getWorkspace().getRoot().findMember(filepath, true);
            if (file == null) {
                if (ApiPlugin.DEBUG_FILTER_STORE) {
                    System.out.println(".api_filter file not found during initialization for project [" + this.fProject.getElementName() + "]");
                }
                return;
            }
            xml = null;
            contents = null;
            try {
                filterFile = (IFile)file;
                if (filterFile.exists()) {
                    contents = filterFile.getContents();
                    xml = new String(Util.getInputStreamAsCharArray(contents, -1, "UTF-8"));
                }
            }
            catch (CoreException e) {
                ApiPlugin.log(e);
                if (contents != null) {
                    try {
                        contents.close();
                    }
                    catch (IOException v0) {}
                }
                break block40;
            }
            catch (IOException e) {
                try {
                    ApiPlugin.log(e);
                    ** if (contents == null) goto lbl-1000
                }
                catch (Throwable var6_8) {
                    if (contents != null) {
                        try {
                            contents.close();
                        }
                        catch (IOException v2) {}
                    }
                    throw var6_8;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        contents.close();
                    }
                    catch (IOException v1) {}
                }
lbl-1000:
                // 2 sources

                {
                    break block40;
                }
            }
            if (contents == null) break block40;
            try {
                contents.close();
            }
            catch (IOException v3) {}
        }
        if (xml == null) {
            return;
        }
        root = null;
        try {
            root = Util.parseDocument(xml);
        }
        catch (CoreException ce) {
            ApiPlugin.log(ce);
        }
        if (root == null) {
            return;
        }
        if (!root.getNodeName().equals("component")) {
            return;
        }
        component = root.getAttribute("id");
        if (component.length() == 0) {
            return;
        }
        versionValue = root.getAttribute("version");
        currentVersion = Integer.parseInt(IApiXmlConstants.API_FILTER_STORE_CURRENT_VERSION);
        version = 0;
        if (versionValue.length() != 0) {
            try {
                version = Integer.parseInt(versionValue);
            }
            catch (NumberFormatException v4) {}
        }
        if (version != currentVersion) {
            this.fNeedsSaving = true;
            this.persistApiFilters();
            return;
        }
        resources = root.getElementsByTagName("resource");
        newfilters = new ArrayList<IApiProblem>();
        comments = new ArrayList<String>();
        i = 0;
        while (i < resources.getLength()) {
            element = (Element)resources.item(i);
            path = element.getAttribute("path");
            if (path.length() != 0) {
                typeName = element.getAttribute("type");
                if (typeName.length() == 0) {
                    typeName = null;
                }
                if ((project = (IProject)ResourcesPlugin.getWorkspace().getRoot().findMember(component)) != null && (resource = project.findMember((IPath)new Path(path))) != null) {
                    filters = element.getElementsByTagName("filter");
                    j = 0;
                    while (j < filters.getLength()) {
                        element = (Element)filters.item(j);
                        id = ApiFilterStore.loadIntegerAttribute(element, "id");
                        if (id > 0) {
                            messageargs = null;
                            elements = element.getElementsByTagName("message_arguments");
                            if (elements.getLength() == 1) {
                                messageArguments = (Element)elements.item(0);
                                arguments = messageArguments.getElementsByTagName("message_argument");
                                length = arguments.getLength();
                                messageargs = new String[length];
                                k = 0;
                                while (k < length) {
                                    messageArgument = (Element)arguments.item(k);
                                    messageargs[k] = messageArgument.getAttribute("value");
                                    ++k;
                                }
                                comment = element.getAttribute("comment");
                                comments.add(comment.length() < 1 ? null : comment);
                                newfilters.add(ApiProblemFactory.newApiProblem(resource.getProjectRelativePath().toPortableString(), typeName, messageargs, null, null, -1, -1, -1, id));
                            }
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
        this.internalAddFilters(newfilters.toArray(new IApiProblem[newfilters.size()]), comments.toArray(new String[comments.size()]), false);
        newfilters.clear();
    }

    private synchronized void internalAddFilters(IApiProblem[] problems, String[] comments, boolean persist) {
        Set<ApiProblemFilter> filters = null;
        int i = 0;
        while (i < problems.length) {
            IResource resource;
            IApiProblem problem = problems[i];
            ApiProblemFilter filter = new ApiProblemFilter(this.fProject.getElementName(), problem, comments == null ? null : comments[i]);
            String resourcePath = problem.getResourcePath();
            if (resourcePath != null && (resource = this.fProject.getProject().findMember((IPath)new Path(resourcePath))) != null) {
                HashMap pTypeNames = (HashMap)this.fFilterMap.get(resource);
                String typeName = problem.getTypeName();
                if (typeName == null) {
                    typeName = GLOBAL;
                }
                if (pTypeNames == null) {
                    filters = new HashSet();
                    pTypeNames = new HashMap();
                    pTypeNames.put(typeName, filters);
                    this.fFilterMap.put(resource, pTypeNames);
                } else {
                    filters = (Set)pTypeNames.get(typeName);
                    if (filters == null) {
                        filters = new HashSet();
                        pTypeNames.put(typeName, filters);
                    }
                }
                this.fNeedsSaving |= filters.add(filter);
            }
            ++i;
        }
        if (persist) {
            this.persistApiFilters();
        } else {
            this.fNeedsSaving = false;
        }
    }

    public void needsSaving() {
        this.fNeedsSaving = true;
    }

    private static int loadIntegerAttribute(Element element, String name) {
        String value = element.getAttribute(name);
        if (value.length() == 0) {
            return -1;
        }
        try {
            int number = Integer.parseInt(value);
            return number;
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    IPath getFilterFilePath(boolean includeproject) {
        if (includeproject) {
            IPath path = this.fProject.getPath();
            return path.append(SETTINGS_FOLDER).append(".api_filters");
        }
        return new Path(SETTINGS_FOLDER).append(".api_filters");
    }

    static String getLineDelimiterPreference(IFile file) {
        IScopeContext[] scopeContext;
        if (file != null && file.getProject() != null) {
            scopeContext = new IScopeContext[]{new ProjectScope(file.getProject())};
            String lineDelimiter = Platform.getPreferencesService().getString("org.eclipse.core.runtime", "line.separator", null, scopeContext);
            if (lineDelimiter != null) {
                return lineDelimiter;
            }
        }
        scopeContext = new IScopeContext[]{InstanceScope.INSTANCE};
        return Platform.getPreferencesService().getString("org.eclipse.core.runtime", "line.separator", null, scopeContext);
    }

    public synchronized void recordFilterUsage() {
        this.initializeApiFilters();
        this.fUnusedFilters = new HashMap();
        IResource resource = null;
        Map types = null;
        HashSet values = null;
        Iterator iter = this.fFilterMap.keySet().iterator();
        while (iter.hasNext()) {
            resource = (IResource)iter.next();
            types = (Map)this.fFilterMap.get(resource);
            values = new HashSet();
            this.fUnusedFilters.put(resource, values);
            Iterator iter2 = types.keySet().iterator();
            while (iter2.hasNext()) {
                values.addAll((Set)types.get(iter2.next()));
            }
        }
    }

    private void recordFilterUsed(IResource resource, IApiProblemFilter filter) {
        Set unused;
        if (this.fUnusedFilters != null && (unused = (Set)this.fUnusedFilters.get(resource)) != null) {
            unused.remove(filter);
            if (unused.isEmpty()) {
                this.fUnusedFilters.remove(resource);
            }
        }
    }

    public IApiProblemFilter[] getUnusedFilters(IResource resource, String typeName, int[] categories) {
        if (this.fUnusedFilters != null) {
            int size;
            HashSet unused = new HashSet();
            Set set = null;
            if (resource != null) {
                set = (Set)this.fUnusedFilters.get(resource);
                if (set != null) {
                    this.collectFilterFor(set, typeName, unused, categories);
                }
                if (Util.isManifest(resource.getProjectRelativePath())) {
                    IResource res = null;
                    Iterator iter = this.fUnusedFilters.keySet().iterator();
                    while (iter.hasNext()) {
                        res = (IResource)iter.next();
                        if (res.exists() || !res.getProject().equals((Object)resource.getProject())) continue;
                        set = (Set)this.fUnusedFilters.get(res);
                        this.collectFilterFor(set, typeName, unused, categories);
                    }
                }
            } else {
                Iterator iter = this.fUnusedFilters.keySet().iterator();
                while (iter.hasNext()) {
                    set = (Set)this.fUnusedFilters.get(iter.next());
                    if (set == null) continue;
                    unused.addAll(set);
                }
            }
            if ((size = unused.size()) == 0) {
                return NO_FILTERS;
            }
            return unused.toArray(new IApiProblemFilter[size]);
        }
        return NO_FILTERS;
    }

    private void collectFilterFor(Set filters, String typename, Set collector, int[] categories) {
        ApiProblemFilter filter = null;
        Iterator iter = filters.iterator();
        while (iter.hasNext()) {
            String underlyingTypeName;
            filter = (ApiProblemFilter)iter.next();
            IApiProblem underlyingProblem = filter.getUnderlyingProblem();
            if (underlyingProblem == null || this.matchesCategory(underlyingProblem, categories) || (underlyingTypeName = underlyingProblem.getTypeName()) == null || typename != null && !underlyingTypeName.equals(typename)) continue;
            collector.add(filter);
        }
    }

    private boolean matchesCategory(IApiProblem problem, int[] categories) {
        if (categories != null) {
            int cat = problem.getCategory();
            int i = 0;
            while (i < categories.length) {
                if (cat == categories[i]) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public String toString() {
        return "API filter store for component: " + this.fProject.getElementName();
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (this.fTriggeredChange) {
            this.fTriggeredChange = false;
            if (ApiPlugin.DEBUG_FILTER_STORE) {
                System.out.println("ignoring triggered change");
            }
            return;
        }
        if (event.getType() == 1) {
            IPath path = this.getFilterFilePath(true);
            IResourceDelta leafdelta = event.getDelta().findMember(path);
            if (leafdelta == null) {
                return;
            }
            boolean needsbuild = false;
            if (leafdelta.getKind() == 2) {
                if (ApiPlugin.DEBUG_FILTER_STORE) {
                    System.out.println("processed REMOVED delta");
                }
                if (this.fFilterMap != null) {
                    this.fFilterMap.clear();
                    needsbuild = this.fProject.getProject().isAccessible();
                }
            } else if (leafdelta.getKind() == 1 || (leafdelta.getFlags() & 0x100) != 0 || (leafdelta.getFlags() & 0x40000) != 0) {
                IResource resource;
                if (ApiPlugin.DEBUG_FILTER_STORE) {
                    System.out.println("processing ADDED or CONTENT or REPLACED");
                }
                if ((resource = leafdelta.getResource()) != null && resource.getType() == 1) {
                    IFile file;
                    if (ApiPlugin.DEBUG_FILTER_STORE) {
                        System.out.println("processed FILE delta for [" + resource.getName() + "]");
                    }
                    if ((file = (IFile)resource).isAccessible()) {
                        try {
                            this.clearFilters();
                            this.initializeApiFilters();
                        }
                        finally {
                            needsbuild = this.fProject.getProject().isAccessible();
                        }
                    }
                }
            }
            if (needsbuild && !ResourcesPlugin.getWorkspace().isAutoBuilding()) {
                Util.getBuildJob(new IProject[]{this.fProject.getProject()}, 10).schedule();
            }
        }
    }

    private synchronized void clearFilters() {
        if (this.fFilterMap != null) {
            this.fFilterMap.clear();
            this.fFilterMap = null;
        }
    }
}

