/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.breakpoints;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManagerListener;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.VariablesViewModelPresentation;
import org.eclipse.debug.internal.ui.actions.breakpointGroups.PasteBreakpointsAction;
import org.eclipse.debug.internal.ui.actions.breakpointGroups.RemoveFromWorkingSetAction;
import org.eclipse.debug.internal.ui.actions.breakpoints.OpenBreakpointMarkerAction;
import org.eclipse.debug.internal.ui.actions.breakpoints.ShowTargetBreakpointsAction;
import org.eclipse.debug.internal.ui.actions.breakpoints.SkipAllBreakpointsAction;
import org.eclipse.debug.internal.ui.breakpoints.provisional.IBreakpointContainer;
import org.eclipse.debug.internal.ui.breakpoints.provisional.IBreakpointOrganizer;
import org.eclipse.debug.internal.ui.elements.adapters.DefaultBreakpointsViewInput;
import org.eclipse.debug.internal.ui.viewers.model.VirtualFindAction;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ITreeModelViewer;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerInputUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdateListener;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ModelDelta;
import org.eclipse.debug.internal.ui.viewers.model.provisional.TreeModelViewer;
import org.eclipse.debug.internal.ui.viewers.model.provisional.VirtualTreeModelViewer;
import org.eclipse.debug.internal.ui.views.DebugUIViewsMessages;
import org.eclipse.debug.internal.ui.views.breakpoints.BreakpointOrganizerManager;
import org.eclipse.debug.internal.ui.views.breakpoints.BreakpointsDragAdapter;
import org.eclipse.debug.internal.ui.views.breakpoints.BreakpointsDropAdapter;
import org.eclipse.debug.internal.ui.views.breakpoints.ElementComparator;
import org.eclipse.debug.internal.ui.views.variables.VariablesView;
import org.eclipse.debug.internal.ui.views.variables.details.AvailableDetailPanesAction;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IBreakpointOrganizerDelegateExtension;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.operations.RedoActionHandler;
import org.eclipse.ui.operations.UndoActionHandler;

public class BreakpointsView
extends VariablesView
implements IBreakpointManagerListener {
    private static final String ACTION_GOTO_MARKER = "GotoMarker";
    private static final String ACTION_SKIP_BREAKPOINTS = "SkipBreakpoints";
    private static final String ACTION_SHOW_MODEL_BREAKPOINT = "ShowBreakpointsForModel";
    private static final String ACTION_REMOVE_FROM_GROUP = "RemoveFromGroup";
    private static final String KEY_VALUE = "value";
    private Clipboard fClipboard;
    private IBreakpointOrganizer[] fOrganizers;
    private boolean fFirstInputSet = false;
    private UndoActionHandler fUndoAction;
    private RedoActionHandler fRedoAction;
    static /* synthetic */ Class class$0;

    public void dispose() {
        if (this.fClipboard != null) {
            this.fClipboard.dispose();
        }
        DebugPlugin.getDefault().getBreakpointManager().removeBreakpointManagerListener((IBreakpointManagerListener)this);
        this.fUndoAction.dispose();
        this.fRedoAction.dispose();
        super.dispose();
    }

    protected String getDetailPanePreferenceKey() {
        return "Breakpoints.detail.orientation";
    }

    protected String getHelpContextId() {
        return "org.eclipse.debug.ui.breakpoint_view_context";
    }

    protected int getViewerStyle() {
        return 268501794;
    }

    public Viewer createViewer(Composite parent) {
        TreeModelViewer viewer = (TreeModelViewer)super.createViewer(parent);
        this.initBreakpointOrganizers(this.getMemento());
        IPresentationContext presentationContext = viewer.getPresentationContext();
        presentationContext.setProperty("BreakpointOrganizers", this.fOrganizers);
        presentationContext.setProperty("ElementComparator", new ElementComparator(presentationContext));
        return viewer;
    }

    protected IDebugModelPresentation getModelPresentation() {
        if (this.fModelPresentation == null) {
            this.fModelPresentation = new VariablesViewModelPresentation(){

                public String getText(Object element) {
                    IDebugModelPresentation lp = this.getConfiguredPresentation(element);
                    if (lp != null) {
                        return lp.getText(element);
                    }
                    return this.getDefaultText(element);
                }
            };
        }
        return this.fModelPresentation;
    }

    public TreeModelViewer getTreeModelViewer() {
        return (TreeModelViewer)this.getViewer();
    }

    protected void configureToolBar(IToolBarManager tbm) {
        tbm.add((IContributionItem)new Separator("breakpointGroup"));
        tbm.add(this.getAction(ACTION_SHOW_MODEL_BREAKPOINT));
        tbm.add(this.getAction(ACTION_GOTO_MARKER));
        tbm.add(this.getAction(ACTION_SKIP_BREAKPOINTS));
        tbm.add((IContributionItem)new Separator("renderGroup"));
    }

    protected void fillContextMenu(IMenuManager menu) {
        this.updateObjects();
        menu.add((IContributionItem)new Separator("emptyNavigationGroup"));
        menu.add((IContributionItem)new Separator("navigationGroup"));
        menu.add(this.getAction(ACTION_GOTO_MARKER));
        menu.add((IContributionItem)new Separator("emptyBreakpointGroup"));
        menu.add((IContributionItem)new Separator("breakpointGroup"));
        menu.add(this.getAction(PASTE_ACTION));
        Object action = this.getAction(ACTION_REMOVE_FROM_GROUP);
        if (action != null && action.isEnabled()) {
            menu.add(action);
        }
        menu.add((IContributionItem)new Separator("emptyRenderGroup"));
        action = new AvailableDetailPanesAction(this);
        if (this.isDetailPaneVisible() && action.isEnabled()) {
            menu.add(action);
        }
        menu.add((IContributionItem)new Separator("breakpointGroupGroup"));
        menu.add((IContributionItem)new Separator("additions"));
    }

    protected void createActions() {
        OpenBreakpointMarkerAction action = new OpenBreakpointMarkerAction((ISelectionProvider)this.getViewer());
        this.setAction(ACTION_GOTO_MARKER, (IAction)action);
        this.setAction("Double_Click_ActionId", (IAction)action);
        this.setAction(ACTION_SHOW_MODEL_BREAKPOINT, (IAction)new ShowTargetBreakpointsAction(this));
        this.setAction(ACTION_SKIP_BREAKPOINTS, (IAction)new SkipAllBreakpointsAction((IWorkbenchPart)this));
        DebugPlugin.getDefault().getBreakpointManager().addBreakpointManagerListener((IBreakpointManagerListener)this);
        this.fClipboard = new Clipboard(this.getSite().getShell().getDisplay());
        PasteBreakpointsAction paste = new PasteBreakpointsAction(this);
        this.setAction(PASTE_ACTION, (IAction)paste);
        paste.setActionDefinitionId(ActionFactory.PASTE.getCommandId());
        this.setGlobalAction(ActionFactory.PASTE.getId(), (IAction)paste);
        this.getViewer().addSelectionChangedListener((ISelectionChangedListener)paste);
        paste.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_PASTE"));
        RemoveFromWorkingSetAction remove = new RemoveFromWorkingSetAction(this);
        this.setAction(ACTION_REMOVE_FROM_GROUP, (IAction)remove);
        this.getViewer().addSelectionChangedListener((ISelectionChangedListener)remove);
        IUndoContext undoContext = DebugUITools.getBreakpointsUndoContext();
        this.fUndoAction = new UndoActionHandler(this.getSite(), undoContext);
        this.fUndoAction.setActionDefinitionId("org.eclipse.ui.edit.undo");
        this.fRedoAction = new RedoActionHandler(this.getSite(), undoContext);
        this.fRedoAction.setActionDefinitionId("org.eclipse.ui.edit.redo");
        this.setGlobalAction(ActionFactory.UNDO.getId(), (IAction)this.fUndoAction);
        this.setGlobalAction(ActionFactory.REDO.getId(), (IAction)this.fRedoAction);
        this.setGlobalAction(FIND_ACTION, (IAction)new VirtualFindAction(this.getVariablesViewer()));
    }

    protected String getToggleActionLabel() {
        return DebugUIViewsMessages.BreakpointsView_12;
    }

    protected String getPresentationContextId() {
        return "org.eclipse.debug.ui.BreakpointView";
    }

    protected void contextActivated(ISelection selection) {
        IPresentationContext presentationContext = this.getTreeModelViewer().getPresentationContext();
        if (selection == null || selection.isEmpty()) {
            DefaultBreakpointsViewInput input = new DefaultBreakpointsViewInput(presentationContext);
            super.contextActivated((ISelection)new StructuredSelection((Object)input));
        } else {
            super.contextActivated(selection);
        }
        if (this.isAvailable() && this.isVisible()) {
            this.updateAction("ContentAssist");
        }
    }

    protected void setViewerInput(Object context) {
        Object current = this.getViewer().getInput();
        if (current == null && context == null) {
            return;
        }
        if (current != null && current.equals(context)) {
            return;
        }
        this.showViewer();
        this.getViewer().setInput(context);
        if (!this.fFirstInputSet) {
            this.fFirstInputSet = true;
            this.expandAllElementsInViewer();
        }
    }

    protected void viewerInputUpdateComplete(IViewerInputUpdate update) {
        IStatus status = update.getStatus();
        if ((status == null || status.isOK()) && update.getElement() != null) {
            this.setViewerInput(update.getInputElement());
        } else {
            this.setViewerInput(new DefaultBreakpointsViewInput(this.getTreeModelViewer().getPresentationContext()));
        }
    }

    public boolean isTrackingSelection() {
        TreeModelViewer viewer = this.getTreeModelViewer();
        if (viewer != null) {
            return Boolean.TRUE.equals(viewer.getPresentationContext().getProperty("TrackSelection"));
        }
        return false;
    }

    public void setTrackSelection(boolean trackSelection) {
        TreeModelViewer viewer = this.getTreeModelViewer();
        if (viewer != null) {
            viewer.getPresentationContext().setProperty("TrackSelection", trackSelection ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    private void initBreakpointOrganizers(IMemento memento) {
        if (memento != null) {
            IMemento node = memento.getChild("breakpointOrganizers");
            if (node == null) {
                this.fOrganizers = null;
            } else {
                String value = node.getString(KEY_VALUE);
                if (value != null) {
                    String[] ids = value.split(",");
                    BreakpointOrganizerManager manager = BreakpointOrganizerManager.getDefault();
                    ArrayList<IBreakpointOrganizer> organziers = new ArrayList<IBreakpointOrganizer>();
                    int i = 0;
                    while (i < ids.length) {
                        IBreakpointOrganizer organizer = manager.getOrganizer(ids[i]);
                        if (organizer != null) {
                            organziers.add(organizer);
                        }
                        ++i;
                    }
                    this.fOrganizers = organziers.toArray(new IBreakpointOrganizer[organziers.size()]);
                    i = 0;
                    while (i < this.fOrganizers.length) {
                        this.fOrganizers[i].addPropertyChangeListener(this);
                        ++i;
                    }
                }
            }
        }
    }

    protected void initDragAndDrop(TreeModelViewer viewer) {
        int ops = 3;
        viewer.addDropSupport(ops, new Transfer[]{LocalSelectionTransfer.getTransfer()}, (DropTargetListener)new BreakpointsDropAdapter(viewer, this));
        viewer.addDragSupport(ops, new Transfer[]{LocalSelectionTransfer.getTransfer()}, (DragSourceListener)new BreakpointsDragAdapter((AbstractTreeViewer)viewer, this));
    }

    public void saveViewerState(IMemento memento) {
        StringBuffer buffer = new StringBuffer();
        if (this.fOrganizers != null) {
            int i = 0;
            while (i < this.fOrganizers.length) {
                IBreakpointOrganizer organizer = this.fOrganizers[i];
                buffer.append(organizer.getIdentifier());
                if (i < this.fOrganizers.length - 1) {
                    buffer.append(',');
                }
                ++i;
            }
            IMemento node = memento.createChild("breakpointOrganizers");
            node.putString(KEY_VALUE, buffer.toString());
        }
        super.saveViewerState(memento);
    }

    public void preserveSelection(IStructuredSelection selection) {
        if (selection instanceof ITreeSelection && !selection.isEmpty()) {
            TreeItem parent;
            TreePath path = ((ITreeSelection)selection).getPaths()[0];
            TreeItem item = (TreeItem)((TreeModelViewer)this.getViewer()).findItem(path);
            Object toselect = null;
            TreeItem[] siblings = null;
            if (item != null && (siblings = (parent = item.getParentItem()) != null ? parent.getItems() : item.getParent().getItems()).length > 1) {
                int i = 0;
                while (i < siblings.length) {
                    if (item.equals(siblings[i])) {
                        if (i + 1 >= siblings.length) {
                            toselect = siblings[i - 1].getData();
                            break;
                        }
                        toselect = siblings[i + 1].getData();
                        break;
                    }
                    ++i;
                }
            }
            if (toselect != null) {
                this.getViewer().setSelection((ISelection)new StructuredSelection(toselect), true);
            }
        }
    }

    public void setBreakpointOrganizers(IBreakpointOrganizer[] organizers) {
        this.fOrganizers = organizers;
        TreeModelViewer viewer = this.getTreeModelViewer();
        if (viewer != null) {
            viewer.getPresentationContext().setProperty("BreakpointOrganizers", this.fOrganizers);
        }
    }

    public void setFilterSelection(boolean filter) {
        TreeModelViewer viewer = this.getTreeModelViewer();
        if (viewer != null) {
            viewer.getPresentationContext().setProperty("FilterSelection", filter ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    public void breakpointManagerEnablementChanged(boolean enabled) {
        DebugUIPlugin.getStandardDisplay().asyncExec(new Runnable(){

            public void run() {
                IAction action = BreakpointsView.this.getAction(BreakpointsView.ACTION_SKIP_BREAKPOINTS);
                if (action != null) {
                    ((SkipAllBreakpointsAction)action).updateActionCheckedState();
                }
            }
        });
    }

    public void expandAllElementsInViewer() {
        Display display = this.getSite().getShell().getDisplay();
        final VirtualTreeModelViewer virtualViewer = new VirtualTreeModelViewer(display, 0, ((ITreeModelViewer)this.getViewer()).getPresentationContext());
        virtualViewer.setAutoExpandLevel(-1);
        virtualViewer.addViewerUpdateListener(new IViewerUpdateListener(){

            public void viewerUpdatesComplete() {
                ModelDelta stateDelta = new ModelDelta(virtualViewer.getInput(), 0);
                virtualViewer.saveElementState(TreePath.EMPTY, stateDelta, 0x100000);
                ITreeModelViewer treeModelViewer = (ITreeModelViewer)BreakpointsView.this.getViewer();
                if (treeModelViewer != null) {
                    ((ITreeModelViewer)BreakpointsView.this.getViewer()).updateViewer(stateDelta);
                }
                virtualViewer.dispose();
            }

            public void viewerUpdatesBegin() {
            }

            public void updateStarted(IViewerUpdate update) {
            }

            public void updateComplete(IViewerUpdate update) {
            }
        });
        virtualViewer.setInput(this.getViewer().getInput());
    }

    public IBreakpointOrganizer[] getBreakpointOrganizers() {
        return this.fOrganizers;
    }

    public boolean canPaste(Object target, ISelection selection) {
        if (!(target instanceof IBreakpointContainer) || !(selection instanceof IStructuredSelection)) {
            return false;
        }
        if (selection == null || selection.isEmpty()) {
            return false;
        }
        IStructuredSelection ss = (IStructuredSelection)selection;
        IBreakpointContainer container = (IBreakpointContainer)target;
        Iterator iter = ss.iterator();
        while (iter.hasNext()) {
            IBreakpoint breakpoint;
            Object e = iter.next();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.eclipse.debug.core.model.IBreakpoint");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((breakpoint = (IBreakpoint)DebugPlugin.getAdapter(e, (Class)clazz)) != null && !container.contains(breakpoint) && container.getOrganizer().canAdd(breakpoint, container.getCategory())) continue;
            return false;
        }
        return true;
    }

    public boolean performPaste(Object target, ISelection selection) {
        if (target instanceof IBreakpointContainer && selection instanceof IStructuredSelection) {
            IBreakpointContainer container = (IBreakpointContainer)target;
            Object[] objects = ((IStructuredSelection)selection).toArray();
            int i = 0;
            while (i < objects.length) {
                IBreakpoint breakpoint;
                Object object = objects[i];
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.debug.core.model.IBreakpoint");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((breakpoint = (IBreakpoint)DebugPlugin.getAdapter((Object)object, (Class)clazz)) != null) {
                    container.getOrganizer().addBreakpoint(breakpoint, container.getCategory());
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public IBreakpointContainer getRemovableContainer(TreePath path) {
        if (path != null) {
            IBreakpoint breakpoint;
            Object object = path.getLastSegment();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.debug.core.model.IBreakpoint");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((breakpoint = (IBreakpoint)DebugPlugin.getAdapter((Object)object, (Class)clazz)) != null) {
                IBreakpointContainer container = null;
                int i = path.getSegmentCount() - 2;
                while (i > -1) {
                    Object segment = path.getSegment(i);
                    if (segment instanceof IBreakpointContainer && (container = (IBreakpointContainer)segment).contains(breakpoint) && container.getOrganizer() != null && container.getOrganizer().canRemove(breakpoint, container.getCategory())) {
                        return container;
                    }
                    --i;
                }
            }
        }
        return null;
    }

    protected IBreakpointContainer getAddableContainer(TreePath path) {
        if (path != null) {
            IBreakpoint breakpoint;
            Object element = path.getLastSegment();
            if (element instanceof IBreakpointContainer) {
                return (IBreakpointContainer)element;
            }
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.debug.core.model.IBreakpoint");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((breakpoint = (IBreakpoint)DebugPlugin.getAdapter((Object)element, (Class)clazz)) != null) {
                IBreakpointContainer container = null;
                int i = path.getSegmentCount() - 2;
                while (i > -1) {
                    Object segment = path.getSegment(i);
                    if (segment instanceof IBreakpointContainer && (container = (IBreakpointContainer)segment).contains(breakpoint) && container.getOrganizer().canAdd(breakpoint, container.getCategory())) {
                        return container;
                    }
                    --i;
                }
            }
        }
        return null;
    }

    private boolean checkAddableParentContainers(TreePath path, IBreakpoint breakpoint) {
        if (path != null) {
            Object element = null;
            int i = path.getSegmentCount() - 1;
            while (i > -1) {
                IBreakpointContainer container;
                element = path.getSegment(i);
                if (element instanceof IBreakpointContainer && ((container = (IBreakpointContainer)element).contains(breakpoint) || !container.getOrganizer().canAdd(breakpoint, container.getCategory()))) {
                    return false;
                }
                --i;
            }
        }
        return true;
    }

    boolean canDrag(TreePath[] items) {
        if (items == null) {
            return false;
        }
        if (items.length == 0) {
            return false;
        }
        int i = 0;
        while (i < items.length) {
            if (this.getRemovableContainer(items[i]) == null) {
                return false;
            }
            ++i;
        }
        return true;
    }

    void performDrag(TreePath[] paths) {
        List<Object> list;
        IBreakpointContainer container;
        if (paths == null) {
            return;
        }
        HashMap<IBreakpointContainer, ArrayList<IBreakpoint>> containersToBreakpoints = new HashMap<IBreakpointContainer, ArrayList<IBreakpoint>>();
        int i = 0;
        while (i < paths.length) {
            IBreakpoint breakpoint;
            Object object = paths[i].getLastSegment();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.eclipse.debug.core.model.IBreakpoint");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((breakpoint = (IBreakpoint)DebugPlugin.getAdapter((Object)object, (Class)clazz)) != null && (container = this.getRemovableContainer(paths[i])) != null) {
                list = (List)containersToBreakpoints.get(container);
                if (list == null) {
                    list = new ArrayList<IBreakpoint>();
                    containersToBreakpoints.put(container, (ArrayList<IBreakpoint>)list);
                }
                list.add(breakpoint);
            }
            ++i;
        }
        Iterator iterator = containersToBreakpoints.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            container = (IBreakpointContainer)entry.getKey();
            list = (ArrayList<IBreakpoint>)entry.getValue();
            IBreakpointOrganizer organizer = container.getOrganizer();
            IBreakpoint[] breakpoints = list.toArray(new IBreakpoint[list.size()]);
            if (organizer instanceof IBreakpointOrganizerDelegateExtension) {
                IBreakpointOrganizerDelegateExtension extension = (IBreakpointOrganizerDelegateExtension)((Object)organizer);
                extension.removeBreakpoints(breakpoints, container.getCategory());
                continue;
            }
            int i2 = 0;
            while (i2 < breakpoints.length) {
                organizer.removeBreakpoint(breakpoints[i2], container.getCategory());
                ++i2;
            }
        }
    }

    protected boolean performDrop(TreePath target, ITreeSelection selection) {
        if (target == null || selection == null) {
            return false;
        }
        IBreakpointContainer container = this.getAddableContainer(target);
        if (container == null) {
            return false;
        }
        IBreakpointOrganizer organizer = container.getOrganizer();
        ArrayList<IBreakpoint> breakpoints = new ArrayList<IBreakpoint>(selection.size());
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            IBreakpoint breakpoint;
            Object e = iter.next();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.eclipse.debug.core.model.IBreakpoint");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((breakpoint = (IBreakpoint)DebugPlugin.getAdapter(e, (Class)clazz)) == null) continue;
            breakpoints.add(breakpoint);
        }
        if (organizer instanceof IBreakpointOrganizerDelegateExtension) {
            IBreakpointOrganizerDelegateExtension extension = (IBreakpointOrganizerDelegateExtension)((Object)organizer);
            extension.addBreakpoints(breakpoints.toArray(new IBreakpoint[breakpoints.size()]), container.getCategory());
        } else {
            int i = 0;
            while (i < breakpoints.size()) {
                organizer.addBreakpoint((IBreakpoint)breakpoints.get(i), container.getCategory());
                ++i;
            }
        }
        return true;
    }

    boolean canDrop(TreePath target, ITreeSelection selection) {
        if (selection == null || target == null) {
            return false;
        }
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            IBreakpoint breakpoint;
            Object e = iter.next();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.eclipse.debug.core.model.IBreakpoint");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((breakpoint = (IBreakpoint)DebugPlugin.getAdapter(e, (Class)clazz)) != null && this.checkAddableParentContainers(target, breakpoint)) continue;
            return false;
        }
        return true;
    }
}

