/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.shared.target;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.ITargetLocation;
import org.eclipse.pde.internal.core.target.IUBundleContainer;
import org.eclipse.pde.internal.ui.shared.target.Messages;
import org.eclipse.pde.ui.target.ITargetLocationUpdater;

public class UpdateTargetJob
extends Job {
    public static final String JOB_FAMILY_ID = "UpdateTargetJob";
    private Map toUpdate;
    private ITargetDefinition fTarget;
    static /* synthetic */ Class class$0;

    public static void update(ITargetDefinition target, Map toUpdate, IJobChangeListener listener) {
        Job.getJobManager().cancel((Object)JOB_FAMILY_ID);
        UpdateTargetJob job = new UpdateTargetJob(toUpdate, target);
        job.setUser(true);
        if (listener != null) {
            job.addJobChangeListener(listener);
        }
        job.schedule();
    }

    private UpdateTargetJob(Map toUpdate, ITargetDefinition target) {
        super(Messages.UpdateTargetJob_UpdateJobName);
        this.toUpdate = toUpdate;
        this.fTarget = target;
    }

    protected IStatus run(IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.UpdateTargetJob_UpdatingTarget, (int)(this.toUpdate.size() * 100));
        MultiStatus errors = new MultiStatus("org.eclipse.pde.core", 0, Messages.UpdateTargetJob_TargetUpdateFailedStatus, null);
        boolean noChange = true;
        Iterator iterator = this.toUpdate.entrySet().iterator();
        while (iterator.hasNext()) {
            ITargetLocationUpdater provider;
            Map.Entry entry = iterator.next();
            ITargetLocation location = (ITargetLocation)entry.getKey();
            Set children = (Set)entry.getValue();
            String path = null;
            try {
                path = location.getLocation(false);
            }
            catch (CoreException coreException) {}
            progress.subTask(NLS.bind((String)Messages.UpdateTargetJob_UpdatingContainer, (Object)path));
            if (location instanceof IUBundleContainer && !children.isEmpty()) {
                try {
                    boolean result = ((IUBundleContainer)location).update((Set)entry.getValue(), (IProgressMonitor)progress.newChild(100));
                    if (!result) continue;
                    noChange = false;
                }
                catch (CoreException e) {
                    errors.add(e.getStatus());
                }
                continue;
            }
            IAdapterManager iAdapterManager = Platform.getAdapterManager();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.eclipse.pde.ui.target.ITargetLocationUpdater");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((provider = (ITargetLocationUpdater)iAdapterManager.getAdapter((Object)location, (Class)clazz)) != null) {
                if (!provider.canUpdate(this.fTarget, location)) continue;
                IStatus result = provider.update(this.fTarget, location, (IProgressMonitor)progress.newChild(100));
                if (result.isOK() && result.getCode() != 101) {
                    noChange = false;
                    continue;
                }
                if (result.isOK()) continue;
                noChange = false;
                errors.add(result);
                continue;
            }
            progress.worked(100);
        }
        progress.done();
        if (noChange) {
            return new Status(0, "org.eclipse.pde.core", 101, Messages.UpdateTargetJob_TargetUpdateSuccessStatus, null);
        }
        if (!errors.isOK()) {
            return errors;
        }
        return Status.OK_STATUS;
    }
}

