/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.actions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.BaseNewWizardMenu;
import org.eclipse.ui.actions.NewExampleAction;
import org.eclipse.ui.actions.NewProjectAction;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.actions.NewWizardShortcutAction;
import org.eclipse.ui.wizards.IWizardCategory;
import org.eclipse.ui.wizards.IWizardDescriptor;

public class NewWizardMenu
extends BaseNewWizardMenu {
    private final IAction newExampleAction;
    private final IAction newProjectAction;
    private boolean enabled = true;

    public NewWizardMenu(IWorkbenchWindow window) {
        this(window, null);
    }

    public NewWizardMenu(IWorkbenchWindow window, String id) {
        super(window, id);
        this.newExampleAction = new NewExampleAction(window);
        this.newProjectAction = new NewProjectAction(window);
    }

    public NewWizardMenu(IMenuManager innerMgr, IWorkbenchWindow window, boolean register) {
        this(window, null);
        this.fillMenu((IContributionManager)innerMgr);
    }

    private void fillMenu(IContributionManager innerMgr) {
        innerMgr.removeAll();
        IContributionItem[] items = this.getContributionItems();
        int i = 0;
        while (i < items.length) {
            innerMgr.add(items[i]);
            ++i;
        }
    }

    public void deregisterListeners() {
    }

    private boolean hasExamples() {
        boolean hasCategory = this.registryHasCategory("org.eclipse.ui.Examples");
        if (hasCategory) {
            IWizardCategory exampleCategory = WorkbenchPlugin.getDefault().getNewWizardRegistry().findCategory("org.eclipse.ui.Examples");
            return this.hasWizards(exampleCategory);
        }
        return false;
    }

    private boolean hasWizards(IWizardCategory category) {
        IWizardDescriptor[] wizards = category.getWizards();
        if (wizards.length > 0) {
            int i = 0;
            while (i < wizards.length) {
                if (!WorkbenchActivityHelper.filterItem((Object)wizards[i])) {
                    return true;
                }
                ++i;
            }
        }
        IWizardCategory[] categories = category.getCategories();
        int i = 0;
        while (i < categories.length) {
            if (this.hasWizards(categories[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void addItems(List list) {
        ArrayList shortCuts = new ArrayList();
        this.addShortcuts(shortCuts);
        Iterator iterator = shortCuts.iterator();
        while (iterator.hasNext()) {
            Object curr = iterator.next();
            if (!(curr instanceof ActionContributionItem) || !this.isNewProjectWizardAction(((ActionContributionItem)curr).getAction())) continue;
            iterator.remove();
            list.add(curr);
        }
        list.add(new ActionContributionItem(this.newProjectAction));
        list.add(new Separator());
        if (!shortCuts.isEmpty()) {
            list.addAll(shortCuts);
            list.add(new Separator());
        }
        if (this.hasExamples()) {
            list.add(new ActionContributionItem(this.newExampleAction));
            list.add(new Separator());
        }
        list.add(new ActionContributionItem(this.getShowDialogAction()));
    }

    private boolean isNewProjectWizardAction(IAction action) {
        if (action instanceof NewWizardShortcutAction) {
            IWizardDescriptor wizardDescriptor = ((NewWizardShortcutAction)action).getWizardDescriptor();
            String[] tags = wizardDescriptor.getTags();
            int i = 0;
            while (i < tags.length) {
                if ("project".equals(tags[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabledValue) {
        this.enabled = enabledValue;
    }

    protected IContributionItem[] getContributionItems() {
        if (this.isEnabled()) {
            return super.getContributionItems();
        }
        return new IContributionItem[0];
    }
}

