#include <stdio.h>
#include <string>
#include <iostream>
#include <fstream>
#include <vector>

#define TAMANO_LINEA 256//para ocupar funcion fgets

void DFS_visit(int u);//prototipo funcion DFS_visit

int tiempo,size,v;//variables globales para tiempos de entrada y salida de visitas al nodo, tamao del grafo, 
int *d,*f,*p;//punteros para definir arreglos de tiempo entrada, tiempo de salida y arreglo de padres de cada nodo del grafo
int **matrix;//para definir matriz de tamao variable				
char *color;//arreglo de colores para los nodos del grafo

void main(int argc,char * argv[]) 
{
	FILE * fd;
	int vertice,adyacente;
	char linea[TAMANO_LINEA],*dato;
  
	fd=stdin;
	
	if (argc!=2)// error en el ingreso de parametros...
	{
		cout<<"\nError....\n\tUso: testCiclo <archivo_de_entrada>\n"<<endl;
		exit(1);
	}

	else if ((fd=fopen(argv[1],"r"))==NULL)// error: no se puede abrir el archivo entregado... 
	{
		cout<<"\nError: no se pudo abrir el archivo "<<argv[1]<<", compruebe que el archivo existe...\n"<<endl;
		exit(1);
	}
  
	fscanf(fd, "%i \n", &size);//obtiene tamao del grafo y lo almacena en size

	matrix=(int **)malloc((size)*sizeof(int));//creo matriz de tamao variable para adyacencias
	for(int i=0;i<size;i++)
		matrix[i]=(int*)malloc((size)*sizeof(int));

	for(int i=0; i<size; i++)//inicializo la matriz con ceros
		for(int j=0; j<size; j++)
			matrix[i][j]=0;

	for (int i=0; i<size; i++)//leo cada linea del archivo ingresado 
	{
		fgets(linea, TAMANO_LINEA, fd);//obtiene linea completa   
		vertice=atoi(strtok(linea," \t\n"));//separa la linea obtenida por los delimitadores espacio, tabulacion y retorno de carro

		while((dato=strtok(NULL," \t\n")) != NULL)
		{
			adyacente=atoi(dato);
			matrix[adyacente][vertice]=1;//lleno la matriz de adyacencia
		}
	}

	system("clear");//limpio pantalla para desplegar resultados de la busqueda de ciclos
	cout<<"Verificando ciclos en el grafo descrito en "<<argv[1]<<"..."<<endl;
	cout<<"\nNumero de vertices del grafo: "<<size<<endl;

	cout<<"\nMatriz de Adyacencia: (un 1 significa existencia del arco i-j)\n"<<endl;//muestro por pantalla la matriz de adyacencia

	cout<<"i\\j ";
	for(int i=0;i<size;i++)
		cout<<i<<" ";
	cout<<endl;

	for(int j=0;j<size;j++)
	{
		cout<<j<<"   ";
		for(int i=0;i<size;i++)
		{
			cout<<matrix[i][j]<<" ";
		}
		cout<<endl;
	}
	cout<<endl;

//********************************Comienzo de codigo DFS******************************************

	d=(int *) malloc((size)*sizeof(int)); //solicito memoria para crear el arreglo de tiempos de entrada al nodo (del tamao pedido por el usuario)
	f=(int *) malloc((size)*sizeof(int)); //solicito memoria para crear el arreglo de tiempos de salida al nodo (del tamao pedido por el usuario)
	p=(int *) malloc((size)*sizeof(int)); //solicito memoria para crear el arreglo de tiempos de padres de los nodos (del tamao pedido por el usuario)
	color=(char *) malloc((size)*sizeof(char)); //solicito memoria para crear el arreglo de colores del nodo (del tamao pedido por el usuario)

	for (int i=0; i<size; i++) 
	{
		color[i]='b';//inicializo todos los colores con blanco
		p[i]=-1;//todos los nodos tienen padre "NULL" al comienzo  
	}

	tiempo=0;

	for (int i=0; i<size; i++)//loop exterior del codigo DFS que llama a cada nodo del grafo
	{
		if(color[i]=='b')//si el nodo no ha sido visitado, visitarlo
			DFS_visit(i);
	}

	cout<<"No existen ciclos en el grafo descrito en "<<argv[1]<<"\n"<<endl;//si el programa llega aqui, no detecto ningun ciclo 
	
	free(d);//libero memoria solicitada para arreglo d
	free(f);//libero memoria solicitada para arreglo f 
	free(p);//libero memoria solicitada para arreglo p 
	free(color);//libero memoria solicitada para arreglo color
}

//*****************************Comienzo codigo DFS_visit******************************************
void DFS_visit(int u)
{
	vector<int> ciclo;//vector creado para mostrar por pantalla secuencia del ciclo encontrado

	color[u]='p';//cambio el color del nodo que estoy visitando a plomo  
	d[u]=++tiempo;//incremento el tiempo de entrada del nodo que estoy visitando 
	
	for(int i=0;i<size;i++)//para cada nodo adyacente al nodo que estoy visitando 
	{
		if(matrix[i][u]==1)//si el la matriz existe un 1 en la posicion i,u; el nodo i es adyacente al nodo visitado
		{
			cout<<"Arco encontrado: "<<u<<"-"<<i<<endl;
			v=i;
			cout<<"nodo visitado: "<<v<<endl;//muestro el nodo que estoy visitando
			cout<<"color del nodo visitado: "<<color[v]<<"\n"<<endl;//muestro el color del nodo que estoy visitando

			if((color[v]=='p')||(color[v]=='n'))//si el color es plomo o negro, ya visite este nodo y he encontrado un ciclo
			{
				ciclo.push_back(u);//ingreso al vector el nodo u para desplegar la secuencia del ciclo
				while(p[u]!=i)//recorro el arreglo de padres hasta llegar al nodo plomo
				{
					ciclo.push_back(p[u]);//ingreso nodo al vector
					u=p[u];//subo al padre de u
				}
				ciclo.push_back(i);//finalmente ingreso al vector el nodo i para desplegarlo en la secuencia
				
				cout<<"Ciclo encontrado, correspondiente a la secuencia: ";
				for(int i=ciclo.size()-1; i>0; i--)//recorro el vector de atras hacia adelante para obtener la secuencia del ciclo
					cout<<ciclo[i]<<" -> ";
				cout<<ciclo[0]<<" -> "<<ciclo[ciclo.size()-1]<<"\n"<<endl;
				
				free(f);//libero memoria solicitada para arreglo f
				free(d);//libero memoria solicitada para arreglo d
				free(p);//libero memoria solicitada para arreglo p
				free(color);//libero memoria solicitada para arreglo color

				exit(0);//fin del programa, existen ciclos en el grafo
			}

			else if(color[v]=='b')//si el nodo que estoy visitando es de color blanco, llamo nuevamente a DFS_visit para este nodo (recorrido en profundidad) 
			{
				p[v]=u;//el padre de v es u
				DFS_visit(v);
			}
		}
	}
	color[u]='n';//termine el recorrido para el nodo u y cambio su color a negro
	f[u]=++tiempo;//ingreso el tiempo de salida para el nodo u en su respectivo arreglo
}

